/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.criteria;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.QueryException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.LoadQueryInfluencers;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.loader.OuterJoinLoader;
import org.hibernate.loader.criteria.CriteriaJoinWalker;
import org.hibernate.loader.criteria.CriteriaQueryTranslator;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public class CriteriaLoader
extends OuterJoinLoader {
    private final CriteriaQueryTranslator translator;
    private final Set querySpaces;
    private final Type[] resultTypes;
    private final String[] userAliases;

    public CriteriaLoader(OuterJoinLoadable persister, SessionFactoryImplementor factory, CriteriaImpl criteria, String rootEntityName, LoadQueryInfluencers loadQueryInfluencers) throws HibernateException {
        super(factory, loadQueryInfluencers);
        this.translator = new CriteriaQueryTranslator(factory, criteria, rootEntityName, "this_");
        this.querySpaces = this.translator.getQuerySpaces();
        CriteriaJoinWalker walker = new CriteriaJoinWalker(persister, this.translator, factory, criteria, rootEntityName, loadQueryInfluencers);
        this.initFromWalker(walker);
        this.userAliases = walker.getUserAliases();
        this.resultTypes = walker.getResultTypes();
        this.postInstantiate();
    }

    public ScrollableResults scroll(SessionImplementor session, ScrollMode scrollMode) throws HibernateException {
        QueryParameters qp = this.translator.getQueryParameters();
        qp.setScrollMode(scrollMode);
        return this.scroll(qp, this.resultTypes, null, session);
    }

    public List list(SessionImplementor session) throws HibernateException {
        return this.list(session, this.translator.getQueryParameters(), this.querySpaces, this.resultTypes);
    }

    protected ResultTransformer resolveResultTransformer(ResultTransformer resultTransformer) {
        return this.translator.getRootCriteria().getResultTransformer();
    }

    protected boolean areResultSetRowsTransformedImmediately(ResultTransformer transformer) {
        return this.resolveResultTransformer(transformer) != null;
    }

    protected Object getResultColumnOrRow(Object[] row, ResultTransformer transformer, ResultSet rs, SessionImplementor session) throws SQLException, HibernateException {
        String[] aliases;
        Object[] result;
        if (this.translator.hasProjection()) {
            Type[] types = this.translator.getProjectedTypes();
            result = new Object[types.length];
            String[] columnAliases = this.translator.getProjectedColumnAliases();
            int pos = 0;
            for (int i = 0; i < result.length; ++i) {
                int numColumns = types[i].getColumnSpan(session.getFactory());
                if (numColumns > 1) {
                    String[] typeColumnAliases = ArrayHelper.slice(columnAliases, pos, numColumns);
                    result[i] = types[i].nullSafeGet(rs, typeColumnAliases, session, null);
                } else {
                    result[i] = types[i].nullSafeGet(rs, columnAliases[pos], session, null);
                }
                pos += numColumns;
            }
            aliases = this.translator.getProjectedAliases();
        } else {
            result = row;
            aliases = this.userAliases;
        }
        return this.resolveResultTransformer(transformer).transformTuple(result, aliases);
    }

    public Set getQuerySpaces() {
        return this.querySpaces;
    }

    protected String applyLocks(String sqlSelectString, LockOptions lockOptions, Dialect dialect) throws QueryException {
        if (lockOptions == null || lockOptions.getLockMode() == LockMode.NONE && lockOptions.getAliasLockCount() == 0) {
            return sqlSelectString;
        }
        LockOptions locks = new LockOptions(lockOptions.getLockMode());
        locks.setScope(lockOptions.getScope());
        locks.setTimeOut(lockOptions.getTimeOut());
        HashMap<String, String[]> keyColumnNames = dialect.forUpdateOfColumns() ? new HashMap<String, String[]>() : null;
        String[] drivingSqlAliases = this.getAliases();
        for (int i = 0; i < drivingSqlAliases.length; ++i) {
            LockMode lockMode = lockOptions.getAliasSpecificLockMode(drivingSqlAliases[i]);
            if (lockMode == null) continue;
            Lockable drivingPersister = (Lockable)((Object)this.getEntityPersisters()[i]);
            String rootSqlAlias = drivingPersister.getRootTableAlias(drivingSqlAliases[i]);
            locks.setAliasSpecificLockMode(rootSqlAlias, lockMode);
            if (keyColumnNames == null) continue;
            keyColumnNames.put(rootSqlAlias, drivingPersister.getRootTableIdentifierColumnNames());
        }
        return dialect.applyLocksToSql(sqlSelectString, locks, keyColumnNames);
    }

    protected LockMode[] getLockModes(LockOptions lockOptions) {
        String[] entityAliases = this.getAliases();
        if (entityAliases == null) {
            return null;
        }
        int size = entityAliases.length;
        LockMode[] lockModesArray = new LockMode[size];
        for (int i = 0; i < size; ++i) {
            LockMode lockMode = lockOptions.getAliasSpecificLockMode(entityAliases[i]);
            lockModesArray[i] = lockMode == null ? lockOptions.getLockMode() : lockMode;
        }
        return lockModesArray;
    }

    protected boolean isSubselectLoadingEnabled() {
        return this.hasSubselectLoadableCollections();
    }

    protected List getResultList(List results, ResultTransformer resultTransformer) {
        return this.resolveResultTransformer(resultTransformer).transformList(results);
    }
}

