/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities.mapper.relation.lazy.initializor;

import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.SortedMap;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.entities.mapper.relation.lazy.initializor.MapCollectionInitializor;
import org.hibernate.envers.entities.mapper.relation.query.RelationQueryGenerator;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.reader.AuditReaderImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedMapCollectionInitializor
extends MapCollectionInitializor<SortedMap> {
    private final Comparator comparator;

    public SortedMapCollectionInitializor(AuditConfiguration verCfg, AuditReaderImplementor versionsReader, RelationQueryGenerator queryGenerator, Object primaryKey, Number revision, Class<? extends SortedMap> collectionClass, MiddleComponentData elementComponentData, MiddleComponentData indexComponentData, Comparator comparator) {
        super(verCfg, versionsReader, queryGenerator, primaryKey, revision, collectionClass, elementComponentData, indexComponentData);
        this.comparator = comparator;
    }

    @Override
    protected SortedMap initializeCollection(int size) {
        if (this.comparator == null) {
            return (SortedMap)super.initializeCollection(size);
        }
        try {
            return (SortedMap)this.collectionClass.getConstructor(Comparator.class).newInstance(this.comparator);
        }
        catch (InstantiationException e) {
            throw new AuditException(e);
        }
        catch (IllegalAccessException e) {
            throw new AuditException(e);
        }
        catch (NoSuchMethodException e) {
            throw new AuditException(e);
        }
        catch (InvocationTargetException e) {
            throw new AuditException(e);
        }
    }
}

