/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.taglib;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.webapp.taglib.HtmlComponentTagBase;
import org.richfaces.component.UISimpleTogglePanel;

public abstract class SimpleTogglePanelTagBase
extends HtmlComponentTagBase {
    private boolean _openedSet = false;
    private ValueExpression _value = null;

    private void logValueDeprecation(ValueExpression value) {
        FacesContext facesContext = this.getFacesContext();
        facesContext.getExternalContext().log("opened attribute has been already set for component with id: " + this.getId() + "[" + value.getExpressionString() + "]. value attribute is deprecated and thus has been dropped!");
    }

    public void setOpened(ValueExpression opened) {
        if (!this._openedSet && this._value != null) {
            this.logValueDeprecation(this._value);
        }
        this._value = opened;
        this._openedSet = true;
    }

    public void setValue(ValueExpression value) {
        if (!this._openedSet) {
            this._value = value;
        } else {
            this.logValueDeprecation(this._value);
        }
    }

    protected void setProperties(UIComponent component) {
        super.setProperties(component);
        if (this._value != null) {
            if (this._value.isLiteralText()) {
                try {
                    UISimpleTogglePanel panel = (UISimpleTogglePanel)component;
                    panel.setOpened(Boolean.valueOf(this._value.getExpressionString()));
                }
                catch (ELException e) {
                    throw new FacesException((Throwable)e);
                }
            } else {
                component.setValueExpression("value", this._value);
            }
        }
    }

    public void release() {
        super.release();
        this._openedSet = false;
        this._value = null;
    }
}

