/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
package it.laitspa.xsd.resolver;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

import org.apache.log4j.Logger;
import org.w3c.dom.ls.LSInput;

public class InputResolver
  implements LSInput
{

  public static transient Logger logger;
  
  static 
  {
    logger = Logger.getLogger(InputResolver.class);
  }
  
  
  private String publicId;

  private String systemId;

  public String getPublicId()
  {
    return publicId;
  }

  public void setPublicId(String publicId)
  {
    this.publicId = publicId;
  }

  public String getBaseURI()
  {
    return null;
  }

  public InputStream getByteStream()
  {
    return null;
  }

  public boolean getCertifiedText()
  {
    return false;
  }

  public Reader getCharacterStream()
  {
    return null;
  }

  public String getEncoding()
  {
    return null;
  }

  public String getStringData()
  {
    synchronized(inputStream)
    {
      try
      {
        byte[] input = new byte[inputStream.available()];
        inputStream.read(input);
        String contents = new String(input);
        return contents;
      }
      catch(IOException e)
      {
        logger.error("Exception caught while retrieving data.", e);
        return null;
      }
    }
  }

  public void setBaseURI(String baseURI)
  {
  }

  public void setByteStream(InputStream byteStream)
  {
  }

  public void setCertifiedText(boolean certifiedText)
  {
  }

  public void setCharacterStream(Reader characterStream)
  {
  }

  public void setEncoding(String encoding)
  {
  }

  public void setStringData(String stringData)
  {
  }

  public String getSystemId()
  {
    return systemId;
  }

  public void setSystemId(String systemId)
  {
    this.systemId = systemId;
  }

  public BufferedInputStream getInputStream()
  {
    return inputStream;
  }

  public void setInputStream(BufferedInputStream inputStream)
  {
    this.inputStream = inputStream;
  }

  private BufferedInputStream inputStream;

  public InputResolver(String publicId, String sysId, InputStream input)
  {
    this.publicId = publicId;
    this.systemId = sysId;
    this.inputStream = new BufferedInputStream(input);
  }
}
