/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.util.misc;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Dario
 * 
 */
public class IntegerUtils
{
  public static boolean isValid(String s)
  {
    //Pattern p = Pattern.compile("\\d+");
    //Matcher m = p.matcher(s);
    //return m.find();
    Pattern p = Pattern.compile("[+-]{0,1}[^0-9]");
    Matcher m = p.matcher(s);
    return !m.find();
  }

  public static Integer parse(String s)
  {
    if(FormUtils.isEmpty(s))
      return null;

    return new Integer(s);
  }

  public static Long parseLong(String s)
  {
    if(FormUtils.isEmpty(s))
      return null;

    return new Long(s);
  }
  
  public static Integer subtractFloorZero(Integer i1, BigDecimal d2)
  {
    Integer zero = new Integer(0);
    Integer i2 = null;
    
    if(i1 == null)
      i1 = zero;
    
    i2 = (d2 == null) ? zero : new Integer(d2.intValue());
    
    int r = Math.max(0, i1.intValue() - i2.intValue());
   
    return new Integer(r);
  }
  
  public static Integer subtractFloorZero(Integer i1, Integer i2)
  {
    Integer zero = new Integer(0);
    
    if(i1 == null)
      i1 = zero;
    
    if(i2 == null)
      i2 = zero;
    
   int r = Math.max(0, i1.intValue() - i2.intValue());
   
   return new Integer(r);
  }
}
