/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package it.laitspa.cpf.util.misc;

import java.security.MessageDigest;
import java.util.Random;
import org.apache.log4j.Logger;

/**
 *
 * @author Andrea
 */
public class HashUtils
{
  protected static Random rnd = new Random();

  protected static char[] alpha_charset = {
    'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M',
    'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'
  };

  protected static char[] alnum_charset = {
    'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M',
    'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
    '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'
  };

  public static String CalculateMD5Digest(String s)
  {
    Logger logger = Logger.getLogger(HashUtils.class);

    try
    {
      MessageDigest md = MessageDigest.getInstance("MD5");
      byte[] bytes = md.digest(s.getBytes());
      return new String(Base64Utils.encode(bytes));
    }
    catch(Exception e)
    {
      logger.error("Exception caught while calculating MD5 hash.", e);
      return null;
    }
  }
  
  public static String CalculateSHA256Digest(String s)
  {
    Logger logger = Logger.getLogger(HashUtils.class);

    try
    {
      MessageDigest md = MessageDigest.getInstance("SHA-256");
      byte[] bytes = md.digest(s.getBytes());
      return new String(Base64Utils.encode(bytes));
    }
    catch(Exception e)
    {
      logger.error("Exception caught while calculating MD5 hash.", e);
      return null;
    }
  }


  public static String generateRandomPassword(int length, boolean includeDigits)
  {
    String s = new String();

    for(int i = 0; i < length; ++i)
      s += includeDigits ?
          alnum_charset[rnd.nextInt(alnum_charset.length)] :
          alpha_charset[rnd.nextInt(alpha_charset.length)];

    return s;
  }
}
