/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
package it.laitspa.cpf.util.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 
 * @author Dario
 * 
 */
public class Base64Utils
{
  private static char[]          map1     = new char[64];
  private static final String    b64regex =
                                              "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
  static
  {
    int i = 0;
    for(char c = 'A'; c <= 'Z'; c++)
      map1[i++] = c;
    for(char c = 'a'; c <= 'z'; c++)
      map1[i++] = c;
    for(char c = '0'; c <= '9'; c++)
      map1[i++] = c;
    map1[i++] = '+';
    map1[i++] = '/';
  }

  private static byte[]          map2     = new byte[128];
  static
  {
    for(int i = 0; i < map2.length; i++)
      map2[i] = -1;
    for(int i = 0; i < 64; i++)
      map2[map1[i]] = (byte)i;
  }

  private static List<Character> mapA     = new ArrayList<Character>();
  static
  {
    for(char c : map1)
      mapA.add(c);

    // Append padding character
    //
    mapA.add('=');
  }

  public static String encodeString(String s)
  {
    return new String(encode(s.getBytes()));
  }

  public static String encodeString(byte[] in)
  {
    return new String(encode(in));
  }

  public static char[] encode(byte[] in)
  {
    return encode(in, in.length);
  }

  public static char[] encode(byte[] in, int iLen)
  {
    int oDataLen = (iLen * 4 + 2) / 3;
    int oLen = ((iLen + 2) / 3) * 4;
    char[] out = new char[oLen];
    int ip = 0;
    int op = 0;
    while(ip < iLen)
    {
      int i0 = in[ip++] & 0xff;
      int i1 = ip < iLen ? in[ip++] & 0xff : 0;
      int i2 = ip < iLen ? in[ip++] & 0xff : 0;
      int o0 = i0 >>> 2;
      int o1 = ((i0 & 3) << 4) | (i1 >>> 4);
      int o2 = ((i1 & 0xf) << 2) | (i2 >>> 6);
      int o3 = i2 & 0x3F;
      out[op++] = map1[o0];
      out[op++] = map1[o1];
      out[op] = op < oDataLen ? map1[o2] : '=';
      op++;
      out[op] = op < oDataLen ? map1[o3] : '=';
      op++;
    }
    return out;
  }

  public static String decodeString(String s)
  {
    return new String(decode(s));
  }

  public static byte[] decode(String s)
  {
    // Added to manage error with char \n inside String s.
    //
    StringBuffer bf = new StringBuffer();

    for(char c : s.toCharArray())
      if(mapA.contains(c))
        bf.append(c);

    return decode(bf.toString().toCharArray());
  }

  public static byte[] decode(char[] in)
  {
    int iLen = in.length;
    if(iLen % 4 != 0)
      throw new IllegalArgumentException(
          "Length of Base64 encoded input string is not a multiple of 4. (" + iLen + ")");
    while(iLen > 0 && in[iLen - 1] == '=')
      iLen--;
    int oLen = (iLen * 3) / 4;
    byte[] out = new byte[oLen];
    int ip = 0;
    int op = 0;
    while(ip < iLen)
    {
      int i0 = in[ip++];
      int i1 = in[ip++];
      int i2 = ip < iLen ? in[ip++] : 'A';
      int i3 = ip < iLen ? in[ip++] : 'A';
      if(i0 > 127 || i1 > 127 || i2 > 127 || i3 > 127)
        throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
      int b0 = map2[i0];
      int b1 = map2[i1];
      int b2 = map2[i2];
      int b3 = map2[i3];
      if(b0 < 0 || b1 < 0 || b2 < 0 || b3 < 0)
        throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
      int o0 = (b0 << 2) | (b1 >>> 4);
      int o1 = ((b1 & 0xf) << 4) | (b2 >>> 2);
      int o2 = ((b2 & 3) << 6) | b3;
      out[op++] = (byte)o0;
      if(op < oLen)
        out[op++] = (byte)o1;
      if(op < oLen)
        out[op++] = (byte)o2;
    }

    return out;
  }

  public static boolean isBase64(String s)
  {
    if (s == null || s.trim().length() == 0)
      return false;
    
    Pattern p = Pattern.compile(b64regex);
    Matcher m = p.matcher(s);
    return m.matches();
  }
}
