/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
package it.laitspa.cpf.util.hibernate;

import java.util.Arrays;

import org.hibernate.Hibernate;
import org.hibernate.SQLQuery;
import org.hibernate.Session;


public class SequenceUtil
{
  protected static String schema = "CARLOWNR";
  
  public static Integer nextSequenceValue(Session session, String sequence)
  {
    String sql = "select " + sequence.trim() + ".NEXTVAL as id from dual ";
    SQLQuery query = session.createSQLQuery(sql);
    query.addScalar("id", Hibernate.INTEGER);
    
    Integer nextval = (Integer)query.uniqueResult();
    
    return nextval;
  }

  public static String buildCode(Session session, String sequence, String prefix, int length)
  {
    Integer codice = SequenceUtil.nextSequenceValue(session, sequence);
    
    char[] chars = new char[length];
    Arrays.fill(chars, '0');
    String s = new String(chars);
    
    s = s + codice.toString();
    s = s.substring(s.length() - length + prefix.length());
    
    return prefix + s;
  }
}
