/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.spring.sogei;

import it.gov.fatturapa.sdi.fatturapa.v1.FatturaElettronicaType;
import it.gov.fatturapa.sdi.messaggi.v1.MetadatiInvioFileType;
import it.laitspa.cpf.model.QueryResult;
import it.laitspa.cpf.model.sogei.evento.EventoSogei;
import it.laitspa.cpf.model.sogei.fattura.FatturaSogei;
import it.laitspa.cpf.model.sogei.inviofilesdi.AllegatoInvioFileSdiSogei;
import it.laitspa.cpf.model.sogei.inviofilesdi.InvioFileSdiSogei;
import it.laitspa.cpf.model.sogei.notifica.NotificaSogei;
import it.laitspa.cpf.model.sogei.soggetto.SoggettoSogei;

import java.math.BigInteger;
import java.util.Date;
import java.util.List;

/**
 * @author andrea
 * 
 */
public interface SogeiFacade
{

  boolean serializeFatturaSogei(Integer codiceInvioSogei);

  boolean serializeLoadFatturaSogei(BigInteger identificativo, String nomeFile,
      String nomeFileMetaDati, MetadatiInvioFileType metadati, byte[] meta, byte[] xml_fattura);

  void
      receiveNotificaDecorrenza(BigInteger identificativoSdi, String nomeFile, byte[] data_response);

  QueryResult listQueryResult(Integer codiceEmittente, Date dataCaricamentoDa,
      Date dataCaricamentoA, String partitaIvaCedente, String partitaIvaCommittente,
      String codiceIpa, Integer codiceStato, 
      String numeroFattura, Date dataFatturaDa, Date dataFatturaA, 
      int s, int ps);

  List<NotificaSogei> listN(Integer codice);

  byte[] createX(Integer codice);

  boolean notificaEsitoCommittente(Integer codiceFattura, Integer codiceInvio, Boolean esito);

  InvioFileSdiSogei getNextToBeLoaded();

  SoggettoSogei retrieveSoggettoForUtente(Integer codiceUtente);

  void serializeCaricamentoFlusso(Integer codiceFlusso, Integer codiceSogettoEmittente,
      FatturaElettronicaType fattura);

  QueryResult listFluxByCodiceEmittente(Integer codiceEmittente, Date dataCaricamentoDa,
      Date dataCaricamentoA, String partitaIvaCedente, String partitaIvaCommittente, String codiceIpa, int startRow,
      int pageSize);

  AllegatoInvioFileSdiSogei retrieveAllegato(Integer codiceInvio, Integer codiceTipoAllegato);

  boolean serializeSignedAllegatoForFlux(Integer codiceFlusso, String file_name, String estensione,
      byte[] data);

  void receiveRicevutaConsegna(BigInteger identificativoSdi, String nomeFile, byte[] data_response);

  void receiveNotificaScarto(BigInteger identificativoSdi, String nomeFile, byte[] data_response);

  void receiveMancataConsegna(BigInteger identificativoSdi, String nomeFile, byte[] data_response);

  void receiveNotificaEsito(BigInteger identificativoSdi, String nomeFile, byte[] data_response);

  void receiveAttestazioneTrasmissione(BigInteger identificativoSdi, String nomeFile,
      byte[] data_response);

  NotificaSogei getNextNotificaToBeLoaded();

  boolean serializeNotificaSogei(Integer codiceNotifica);

  QueryResult listSoggettiByQuery(String denominazione, String cognome, String nome,
      String identificativoFiscale, String codiceFiscale, String codiceIpa, int startRow,
      int pageSize);

  boolean isCodiceIpaAlreadyPresent(String codiceIpa);

  boolean deleteCodiceIpa(Integer codiceIpa);

  void saveCodiceIpaForSoggetto(Integer codiceSoggetto, String codiceIpa);

  List<NotificaSogei> listNF(Integer codice);

  List<EventoSogei> listEv(Integer codice);

  boolean saveAnagraficaSoggetto(Integer codiceSoggetto, String nazione,
      String codiceIdentificativoFiscale, String codiceFiscale, String denominazione, String nome,
      String cognome, String descrizioneTitolare, String descrizioneCodiceEori, String mail);

  Integer serializeCaricamentoFlusso(Integer codiceFlusso, Integer codiceSogettoEmittente,
      FatturaElettronicaType fattura, Integer codiceStato);

  List<Integer> listLottiByStateAndDate(Date dataCreazione, Integer inviato);

  boolean confirmLotto(Integer identificativo);

  public FatturaSogei getFatturaByNumero(String numeroFattura);

}
