/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package it.laitspa.cpf.spring.lut;

import it.laitspa.cpf.model.QueryResult;

import java.io.Serializable;
import java.util.List;

/**
 * 
 * @author Andrea
 */

@SuppressWarnings("rawtypes")
public interface LUTFacade
{

  void deleteItem(Class table, Serializable id);

  Object getItem(String lut, Object codice);

  Object getItemByDescrizione(String lut, String descrizione);

  Object getItemByDescrizione(String lut, String column, Object filter);

  QueryResult query(String lut, int firstResult, int maxResults);

  QueryResult query(String lut, String orderColumn, int firstResult, int maxResults);

  Object retrieveByCodice(String lut, int codice);

  String buildCode(String sequence, String prefix, int length);
  
  List retrieve(String lut);

  List retrieve(String lut, String orderColumn);

  List retrieve(String lut, String orderColumn, String filterColumn, Object filterValue);  

  List retrieveExcludingByCodice(String lut, Integer[] exclude);

  List retrieveExcludingByCodice(String lut, String orderColumn, Integer[] exclude);

  List retrieveExcludingByCodice(String lut, String orderColumn, String filterColumn, Object filterValue, Integer[] exclude);

  List retrieveIncludingByCodice(String lut, Integer[] include);

  List retrieveIncludingByCodice(String lut, String orderColumn, Integer[] include);

  List retrieveIncludingByCodice(String lut, String orderColumn, String filterColumn, String filterValue, Integer[] include);

  List retrieveAdvance(String lut, String orderColumn, String filterColumn, Object filterValue, String[] joins);

  List retrieveAdvance(String lut, String orderColumn, String[] joins);


}
