/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package it.laitspa.cpf.service.utils;

import it.laitspa.cpf.util.sdi.InputStreamDatasource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;

import javax.activation.DataHandler;
import javax.servlet.ServletContext;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;

import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/**
 * 
 * @author andrea
 */
public class WSUtils
{

  private static transient Logger logger;

  static
  {
    logger = Logger.getLogger(WSUtils.class);
  }

  public static Object findBean(String beanName, WebServiceContext context)
  {
    Object res = null;
    try
    {
      ServletContext servletContext = (ServletContext)context.getMessageContext().get(MessageContext.SERVLET_CONTEXT);
      ApplicationContext appContext = WebApplicationContextUtils.getWebApplicationContext(servletContext);
      res = appContext.getBean(beanName);
      if(res == null)
      {
        String msg = "Unable to retrieve spring bean: " + beanName;
        logger.error(msg);
      }
    }
    catch(Exception e)
    {
      logger.error("Unable to find bean: " + beanName);
      logger.error(e);
    }
    return res;
  }

  public static String getThrowableErrorNote(String value, Throwable t)
  {
    StringWriter sw = new StringWriter();
    sw.write(value);
    sw.write("\n");
    t.printStackTrace(new PrintWriter(sw));
    return sw.toString();
  }

  /*
  public static X509CertImpl getUserCertificate()
  {
    try
    {
      // Retrieve HttpRequest from PolicyContext
      //
      HttpServletRequest request = (HttpServletRequest)PolicyContext.getContext(MyBaseCertLoginModule.WEB_REQUEST_KEY);
      X509CertImpl cert = (X509CertImpl) request.getAttribute(MyBaseCertLoginModule.X509CERTIFICATE_KEY);
      return cert;
    }
    catch(Exception e)
    {
      // Return null
      //
      logger.error("Unable to retrieve certificate", e);
      return null;
    }
  }
  */
  
  public static InputStream getStream(DataHandler dh)
  {
    try
    {
      return dh.getInputStream();
    }
    catch(IOException e)
    {
      logger.error("Error while retrieving InputStream from DataHandler.", e);
      return null;
    }
  }

  public static byte[] getData(DataHandler dh)
  {
    ByteArrayOutputStream bos = null;
    try
    {
      bos = new ByteArrayOutputStream();
      dh.writeTo(bos);
      return bos.toByteArray();
    }
    catch(IOException e)
    {
      logger.error("Error while retrieving InputStream from DataHandler.", e);
      return null;
    }
    finally
    {
      if (bos != null)
        try
        {
          bos.close();
        }
        catch(IOException e)
        {
          logger.error("Error while closing OutputStream from DataHandler.", e);
        }
    }
  }

  public static DataHandler toDataHandler(byte[] data)
  {
    ByteArrayInputStream bis = new ByteArrayInputStream(data);
    InputStreamDatasource is = new InputStreamDatasource(bis);
    DataHandler dh = new DataHandler(is);
    return dh;
  }
  
}
