/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.service.lotto;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;

/**
 * @author andrea
 *
 */
@XmlSeeAlso({LottoPrelievoResponse.class, 
  LottoListResponse.class, 
  LottoUploadResponse.class,
  LottoConfermaResponse.class})
@XmlRootElement(name="response")
@XmlAccessorType(XmlAccessType.FIELD)
public abstract class LottoResponse
{

  
  @XmlElement(name = "tipo", required=true)
  private LottoResponseType tipo;
  
  @XmlElement(name = "note")
  private List<String>      note;
  
  public LottoResponseType getTipo()
  {
    return tipo;
  }
  
  public void setTipo(LottoResponseType tipo)
  {
    this.tipo = tipo;
  }
  public List<String> getNote()
  {
    if (note == null)
      note = new ArrayList<String>();
    return note;
  }
  public void setNote(List<String> note)
  {
    this.note = note;
  }
  
  
  
}
