/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.model.sogei.trasporto;

import it.laitspa.cpf.model.Entity;
import it.laitspa.cpf.model.sogei.anagrafica.AnagraficaSogei;
import it.laitspa.cpf.model.sogei.fattura.FatturaSogei;
import it.laitspa.cpf.model.sogei.indirizzo.IndirizzoSogei;

import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

/**
 * @author andrea
 * 
 */
@javax.persistence.Entity
@Table(name = "TAB_SAN_CPF_SOGEI_FATT_TRAS")
public class TrasportoFatturaSogei
  extends Entity
{
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  @Id
  @GeneratedValue(generator = "sdi_gen_trasp", strategy = GenerationType.SEQUENCE)
  @SequenceGenerator(name = "sdi_gen_trasp", sequenceName = "SEQ_SAN_CPF_SOGEI_FATT_TRAS",
      allocationSize = 1)
  @Column(name = "CODI_DATI_TRAS", nullable = false)
  private Integer           codice;

  @ManyToOne(targetEntity = FatturaSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_FATT_SOGE", nullable = false)
  private FatturaSogei      fattura;

  @ManyToOne(targetEntity = AnagraficaSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_ANAG")
  @Cascade(CascadeType.SAVE_UPDATE)
  private AnagraficaSogei   anagrafica;

  @Column(name = "DESC_NUME_LICE", length = 20)
  private String            numeroLicenza;

  @Column(name = "DESC_MEZZ_TRAS", length = 80)
  private String            mezzoTrasporto;

  @Column(name = "DESC_CAUS", length = 100)
  private String            causale;

  @Column(name = "NUME_COLL")
  private Integer           numeroColli;

  @Column(name = "DESC_TRAS", length = 100)
  private String            descrizione;

  @Column(name = "DESC_UNIT_PESO", length = 10)
  private String            unitaMisura;

  @Column(name = "NUME_PESO_LORD")
  private BigDecimal        pesoLordo;

  @Column(name = "NUME_PESO_NETT")
  private BigDecimal        pesoNetto;

  @Temporal(TemporalType.DATE)
  @Column(name = "DATA_RITI")
  private Date              dataRitiro;

  @Temporal(TemporalType.DATE)
  @Column(name = "DATA_TRAS")
  private Date              dataTrasporto;

  @Temporal(TemporalType.DATE)
  @Column(name = "DATA_CONS")
  private Date              dataConsegna;

  @Column(name = "DESC_TIPO_RESA", length = 3)
  private String            tipoResa;

  @ManyToOne(targetEntity = IndirizzoSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_INDI_RESA")
  private IndirizzoSogei    indirizzoResa;

  public Integer getCodice()
  {
    return codice;
  }

  public void setCodice(Integer codice)
  {
    this.codice = codice;
  }

  public FatturaSogei getFattura()
  {
    return fattura;
  }

  public void setFattura(FatturaSogei fattura)
  {
    this.fattura = fattura;
  }

  public AnagraficaSogei getAnagrafica()
  {
    return anagrafica;
  }

  public void setAnagrafica(AnagraficaSogei anagrafica)
  {
    this.anagrafica = anagrafica;
  }

  public String getNumeroLicenza()
  {
    return numeroLicenza;
  }

  public void setNumeroLicenza(String numeroLicenza)
  {
    this.numeroLicenza = numeroLicenza;
  }

  public String getMezzoTrasporto()
  {
    return mezzoTrasporto;
  }

  public void setMezzoTrasporto(String mezzoTrasporto)
  {
    this.mezzoTrasporto = mezzoTrasporto;
  }

  public String getCausale()
  {
    return causale;
  }

  public void setCausale(String causale)
  {
    this.causale = causale;
  }

  public Integer getNumeroColli()
  {
    return numeroColli;
  }

  public void setNumeroColli(Integer numeroColli)
  {
    this.numeroColli = numeroColli;
  }

  public String getDescrizione()
  {
    return descrizione;
  }

  public void setDescrizione(String descrizione)
  {
    this.descrizione = descrizione;
  }

  public String getUnitaMisura()
  {
    return unitaMisura;
  }

  public void setUnitaMisura(String unitaMisura)
  {
    this.unitaMisura = unitaMisura;
  }

  public BigDecimal getPesoLordo()
  {
    return pesoLordo;
  }

  public void setPesoLordo(BigDecimal pesoLordo)
  {
    this.pesoLordo = pesoLordo;
  }

  public BigDecimal getPesoNetto()
  {
    return pesoNetto;
  }

  public void setPesoNetto(BigDecimal pesoNetto)
  {
    this.pesoNetto = pesoNetto;
  }

  public Date getDataRitiro()
  {
    return dataRitiro;
  }

  public void setDataRitiro(Date dataRitiro)
  {
    this.dataRitiro = dataRitiro;
  }

  public Date getDataTrasporto()
  {
    return dataTrasporto;
  }

  public void setDataTrasporto(Date dataTrasporto)
  {
    this.dataTrasporto = dataTrasporto;
  }

  public Date getDataConsegna()
  {
    return dataConsegna;
  }

  public void setDataConsegna(Date dataConsegna)
  {
    this.dataConsegna = dataConsegna;
  }

  public String getTipoResa()
  {
    return tipoResa;
  }

  public void setTipoResa(String tipoResa)
  {
    this.tipoResa = tipoResa;
  }

  public IndirizzoSogei getIndirizzoResa()
  {
    return indirizzoResa;
  }

  public void setIndirizzoResa(IndirizzoSogei indirizzoResa)
  {
    this.indirizzoResa = indirizzoResa;
  }

}
