/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.model.sogei.trasmissione;

import it.laitspa.cpf.model.Entity;
import it.laitspa.cpf.model.sogei.cedente.CedentePrestatoreSogei;
import it.laitspa.cpf.model.sogei.cessionariocommittente.CessionarioCommittenteSogei;
import it.laitspa.cpf.model.sogei.contatto.ContattoSogei;
import it.laitspa.cpf.model.sogei.inviofilesdi.InvioFileSdiSogei;
import it.laitspa.cpf.model.sogei.soggetto.SoggettoSogei;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * @author andrea
 * 
 */
@javax.persistence.Entity
@Table(name = "TAB_SAN_CPF_SOGEI_TRASM")
public class TrasmissioneSogei
  extends Entity
{
  /**
   * 
   */
  private static final long           serialVersionUID = 1L;

  @Id
  @GeneratedValue(generator = "sdi_gen02", strategy = GenerationType.SEQUENCE)
  @SequenceGenerator(name = "sdi_gen02", sequenceName = "SEQ_SAN_CPF_SOGEI_TRASM",
      allocationSize = 1)
  @Column(name = "CODI_TRAS", nullable = false)
  private Integer                     codice;
  @Column(name = "DESC_NAZI", nullable = false)
  private String                      nazione;

  @Column(name = "DESC_IDEN_FISC", nullable = false)
  private String                      codiceIdentificativoFiscale;

  @Column(name = "DESC_PROG_INVI")
  private String                      progressivoInvio;

  @Temporal(TemporalType.TIMESTAMP)
  @Column(name = "DATA_CREA", nullable = false)
  private Date                        dataCreazione    = new Date();

  @Column(name = "DESC_FORM_TRAS")
  private String                      formatoTrasmissione;
  @Column(name = "CODI_DEST")
  private String                      codiceDestinatario;
  @Column(name = "DESC_EMIT")
  private String                      soggettoEmittente;

  @ManyToOne(targetEntity = ContattoSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_CONT")
  private ContattoSogei               contattoTrasmittente;

  @OneToOne(targetEntity = CedentePrestatoreSogei.class, mappedBy = "trasmissione",
      fetch = FetchType.LAZY)
  private CedentePrestatoreSogei      cedente;

  @OneToOne(targetEntity = CessionarioCommittenteSogei.class, mappedBy = "trasmissione",
      fetch = FetchType.LAZY)
  private CessionarioCommittenteSogei cessionario;

  @OneToOne(targetEntity = InvioFileSdiSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_INVI")
  private InvioFileSdiSogei           invio;

  @ManyToOne(targetEntity = SoggettoSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_EMIT")
  private SoggettoSogei               soggettoCedente;

  @ManyToOne(targetEntity = SoggettoSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_COMM")
  private SoggettoSogei               soggettoCessionario;

  public Integer getCodice()
  {
    return codice;
  }

  public void setCodice(Integer codice)
  {
    this.codice = codice;
  }

  public String getNazione()
  {
    return nazione;
  }

  public void setNazione(String nazione)
  {
    this.nazione = nazione;
  }

  public String getCodiceIdentificativoFiscale()
  {
    return codiceIdentificativoFiscale;
  }

  public void setCodiceIdentificativoFiscale(String codiceFiscale)
  {
    this.codiceIdentificativoFiscale = codiceFiscale;
  }

  public String getProgressivoInvio()
  {
    return progressivoInvio;
  }

  public void setProgressivoInvio(String progressivoInvio)
  {
    this.progressivoInvio = progressivoInvio;
  }

  public Date getDataCreazione()
  {
    return dataCreazione;
  }

  public void setDataCreazione(Date dataCreazione)
  {
    this.dataCreazione = dataCreazione;
  }

  public String getFormatoTrasmissione()
  {
    return formatoTrasmissione;
  }

  public void setFormatoTrasmissione(String formatoTrasmissione)
  {
    this.formatoTrasmissione = formatoTrasmissione;
  }

  public String getCodiceDestinatario()
  {
    return codiceDestinatario;
  }

  public void setCodiceDestinatario(String codiceDestinatario)
  {
    this.codiceDestinatario = codiceDestinatario;
  }

  public String getSoggettoEmittente()
  {
    return soggettoEmittente;
  }

  public void setSoggettoEmittente(String soggettoEmittente)
  {
    this.soggettoEmittente = soggettoEmittente;
  }

  public ContattoSogei getContattoTrasmittente()
  {
    return contattoTrasmittente;
  }

  public void setContattoTrasmittente(ContattoSogei contattoTrasmittente)
  {
    this.contattoTrasmittente = contattoTrasmittente;
  }

  public CedentePrestatoreSogei getCedente()
  {
    return cedente;
  }

  public void setCedente(CedentePrestatoreSogei cedente)
  {
    this.cedente = cedente;
  }

  public CessionarioCommittenteSogei getCessionario()
  {
    return cessionario;
  }

  public void setCessionario(CessionarioCommittenteSogei cessionario)
  {
    this.cessionario = cessionario;
  }

  public InvioFileSdiSogei getInvio()
  {
    return invio;
  }

  public void setInvio(InvioFileSdiSogei invio)
  {
    this.invio = invio;
  }

  public SoggettoSogei getSoggettoCedente()
  {
    return soggettoCedente;
  }

  public void setSoggettoCedente(SoggettoSogei soggettoCedente)
  {
    this.soggettoCedente = soggettoCedente;
  }

  public SoggettoSogei getSoggettoCessionario()
  {
    return soggettoCessionario;
  }

  public void setSoggettoCessionario(SoggettoSogei soggettoCessionario)
  {
    this.soggettoCessionario = soggettoCessionario;
  }

}
