/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.model.sogei.soggetto;

import it.laitspa.cpf.model.DAO;

import org.hibernate.Query;
import org.hibernate.Session;

/**
 * @author andrea
 *
 */
public class SoggettoSogeiDAO
  extends DAO
{

  public SoggettoSogeiDAO(Session session)
  {
    super(session);
  }

  public SoggettoSogei retrieveByCodiceIpa(String codiceIpa)
  {
    String hql = "select s from SoggettoSogei s "
        + "inner join s.codiciIpa cod "
        + "where cod.codiceIpa = upper(:codiceIpa) ";
    Query q = session.createQuery(hql);
    q.setParameter("codiceIpa", codiceIpa);
    
    SoggettoSogei soggetto = (SoggettoSogei)q.uniqueResult();
    logger.info("retrieveByCodiceIpa returned " + soggetto + " for codiceIpa " + codiceIpa);
    return soggetto;
  }
  
  public SoggettoSogei retrieveByPivaOrCF(String nazione, String partitaIva, String codiceFiscale)
  {
    if (partitaIva == null && codiceFiscale == null)
    {
      logger.warn("retrieveByPivaOrCF returned null for null parameters.");
      return null;
    }
    
    if (partitaIva != null && nazione == null)
    {
      logger.warn("retrieveByPivaOrCF returned null for null nazione parameter and partitaIva value.");
      return null;
    }
    
    String hql = "select s from SoggettoSogei s ";
    
    if (partitaIva != null)
    {
      hql += "where (s.nazione = :nazione and s.codiceIdentificativoFiscale = upper(:partitaIva)) ";
      if (codiceFiscale != null)
        hql += "or s.codiceFiscale = upper(:codiceFiscale) ";
      
    }
    else
    {
      hql += "where s.codiceFiscale = upper(:codiceFiscale) ";
    }
    
        
    Query q = session.createQuery(hql);
    q.setMaxResults(1);
    
    if (nazione != null)
      q.setParameter("nazione", nazione);    
    if (partitaIva != null)
      q.setParameter("partitaIva", partitaIva);
    if (codiceFiscale != null)
      q.setParameter("codiceFiscale", codiceFiscale);    
    
    SoggettoSogei soggetto = (SoggettoSogei)q.uniqueResult();
    logger.info("retrieveByPivaOrCF returned " + soggetto + " for codiceFiscale " + codiceFiscale + " and partitaIva " + partitaIva);
    return soggetto;
  }
  
  public SoggettoSogei retrieveSoggettoForUtente(Integer codiceUtente)
  {
    throw new UnsupportedOperationException("Operazione non implementata.");
  }
  
}
