/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.model.sogei.soggetto;

import it.laitspa.cpf.model.Entity;
import it.laitspa.cpf.model.sogei.trasmissione.TrasmissioneSogei;

import java.util.Date;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * @author andrea
 * 
 */
@javax.persistence.Entity
@Table(name = "TAB_SAN_CPF_SOGEI_SOGGETTO")
public class SoggettoSogei
  extends Entity
{
  /**
   * 
   */
  private static final long      serialVersionUID = 1L;

  public static Integer          SOGGETTO_UNICO   = new Integer(1);

  @Id
  @Column(name = "CODI_SOGG")
  private Integer                codice;

  @Temporal(TemporalType.TIMESTAMP)
  @Column(name = "DATA_CREA", nullable = false)
  private Date                   dataCreazione    = new Date();

  @Column(name = "DESC_NAZI")
  private String                 nazione;

  @Column(name = "DESC_IDEN_FISC", length = 50)
  private String                 codiceIdentificativoFiscale;

  @Column(name = "DESC_CODI_FISC", length = 50)
  private String                 codiceFiscale;

  @Column(name = "DESC_DENO", length = 80)
  private String                 denominazione;
  @Column(name = "DESC_NOME", length = 60)
  private String                 nome;
  @Column(name = "DESC_COGN", length = 60)
  private String                 cognome;
  @Column(name = "DESC_TITO", length = 10)
  private String                 descrizioneTitolare;

  @Column(name = "DESC_EORI", length = 17)
  private String                 descrizioneCodiceEori;

  @Column(name = "DESC_MAIL", length = 50)
  private String                 mail;

  @OneToMany(targetEntity = CodiceIpaSogei.class, mappedBy = "soggetto", fetch = FetchType.LAZY)
  private Set<CodiceIpaSogei>    codiciIpa;

  @OneToMany(targetEntity = TrasmissioneSogei.class, mappedBy = "soggettoCedente",
      fetch = FetchType.LAZY)
  private Set<TrasmissioneSogei> trasmissioniCedute;

  @OneToMany(targetEntity = TrasmissioneSogei.class, mappedBy = "soggettoCessionario",
      fetch = FetchType.LAZY)
  private Set<TrasmissioneSogei> trasmissioniAcquisite;

  public Integer getCodice()
  {
    return codice;
  }

  public void setCodice(Integer codice)
  {
    this.codice = codice;
  }

  public Date getDataCreazione()
  {
    return dataCreazione;
  }

  public void setDataCreazione(Date dataCreazione)
  {
    this.dataCreazione = dataCreazione;
  }

  public String getNazione()
  {
    return nazione;
  }

  public void setNazione(String nazione)
  {
    this.nazione = nazione;
  }

  public String getCodiceIdentificativoFiscale()
  {
    return codiceIdentificativoFiscale;
  }

  public void setCodiceIdentificativoFiscale(String codiceIdentificativoFiscale)
  {
    this.codiceIdentificativoFiscale = codiceIdentificativoFiscale;
  }

  public String getCodiceFiscale()
  {
    return codiceFiscale;
  }

  public void setCodiceFiscale(String codiceFiscale)
  {
    this.codiceFiscale = codiceFiscale;
  }

  public String getDenominazione()
  {
    return denominazione;
  }

  public void setDenominazione(String denominazione)
  {
    this.denominazione = denominazione;
  }

  public String getNome()
  {
    return nome;
  }

  public void setNome(String nome)
  {
    this.nome = nome;
  }

  public String getCognome()
  {
    return cognome;
  }

  public void setCognome(String cognome)
  {
    this.cognome = cognome;
  }

  public String getDescrizioneTitolare()
  {
    return descrizioneTitolare;
  }

  public void setDescrizioneTitolare(String descrizioneTitolare)
  {
    this.descrizioneTitolare = descrizioneTitolare;
  }

  public String getDescrizioneCodiceEori()
  {
    return descrizioneCodiceEori;
  }

  public void setDescrizioneCodiceEori(String descrizioneCodiceEori)
  {
    this.descrizioneCodiceEori = descrizioneCodiceEori;
  }

  public Set<TrasmissioneSogei> getTrasmissioniCedute()
  {
    return trasmissioniCedute;
  }

  public void setTrasmissioniCedute(Set<TrasmissioneSogei> trasmissioniCedute)
  {
    this.trasmissioniCedute = trasmissioniCedute;
  }

  public Set<TrasmissioneSogei> getTrasmissioniAcquisite()
  {
    return trasmissioniAcquisite;
  }

  public void setTrasmissioniAcquisite(Set<TrasmissioneSogei> trasmissioniAcquisite)
  {
    this.trasmissioniAcquisite = trasmissioniAcquisite;
  }

  public Set<CodiceIpaSogei> getCodiciIpa()
  {
    return codiciIpa;
  }

  public void setCodiciIpa(Set<CodiceIpaSogei> codiciIpa)
  {
    this.codiciIpa = codiciIpa;
  }

  public String getMail()
  {
    return mail;
  }

  public void setMail(String mail)
  {
    this.mail = mail;
  }

}
