/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.model.sogei.soggetto;

import org.hibernate.Query;
import org.hibernate.Session;

import it.laitspa.cpf.model.QueryPaging;

/**
 * @author andrea
 *
 */
public class QSQuery
  extends QueryPaging
{

  private String denominazione;
  private String cognome;
  private String nome;
  private String identificativoFiscale;
  private String codiceFiscale;
  private String codiceIpa;
  
  public QSQuery(Session session)
  {
    super(session);
  }

  public String getDenominazione()
  {
    return denominazione;
  }

  public void setDenominazione(String denominazione)
  {
    this.denominazione = denominazione;
  }

  public String getCognome()
  {
    return cognome;
  }

  public void setCognome(String cognome)
  {
    this.cognome = cognome;
  }

  public String getNome()
  {
    return nome;
  }

  public void setNome(String nome)
  {
    this.nome = nome;
  }

  public String getIdentificativoFiscale()
  {
    return identificativoFiscale;
  }

  public void setIdentificativoFiscale(String identificativoFiscale)
  {
    this.identificativoFiscale = identificativoFiscale;
  }

  public String getCodiceFiscale()
  {
    return codiceFiscale;
  }

  public void setCodiceFiscale(String codiceFiscale)
  {
    this.codiceFiscale = codiceFiscale;
  }

  public String getCodiceIpa()
  {
    return codiceIpa;
  }

  public void setCodiceIpa(String codiceIpa)
  {
    this.codiceIpa = codiceIpa;
  }

  /* (non-Javadoc)
   * @see it.laitspa.cpf.model.QueryPaging#checkQueryArguments()
   */
  @Override
  protected boolean checkQueryArguments()
  {
    return true;
  }

  /* (non-Javadoc)
   * @see it.laitspa.cpf.model.QueryPaging#getListHql()
   */
  @Override
  protected String getListHql()
  {
    String hql = "select s.codice "
        + "from SoggettoSogei s ";
    if (codiceIpa != null)
      hql += "inner join s.codiciIpa ci ";
    
    boolean firstArg = true;
    
    if(codiceFiscale != null)
    {
      if(firstArg)
      {
        hql += "where ";
        firstArg = false;
      }
      else
        hql += "and ";
      hql += "upper(s.codiceFiscale) like :codiceFiscale ";
    }
    
    if(identificativoFiscale != null)
    {
      if(firstArg)
      {
        hql += "where ";
        firstArg = false;
      }
      else
        hql += "and ";
      hql += "upper(s.codiceIdentificativoFiscale) like :identificativoFiscale ";
    }
    
    if(cognome != null)
    {
      if(firstArg)
      {
        hql += "where ";
        firstArg = false;
      }
      else
        hql += "and ";
      hql += "upper(s.cognome) like :cognome ";
    }   
    
    if(nome != null)
    {
      if(firstArg)
      {
        hql += "where ";
        firstArg = false;
      }
      else
        hql += "and ";
      hql += "upper(s.nome) like :nome ";
    }    
    
    if(denominazione != null)
    {
      if(firstArg)
      {
        hql += "where ";
        firstArg = false;
      }
      else
        hql += "and ";
      hql += "upper(s.denominazione) like :denominazione ";
    } 
    
    if(codiceIpa != null)
    {
      if(firstArg)
      {
        hql += "where ";
        firstArg = false;
      }
      else
        hql += "and ";
      hql += "ci.codiceIpa = :codiceIpa ";
    } 
    
    
    hql += "order by s.codice";
    
    return hql;
  }

  /* (non-Javadoc)
   * @see it.laitspa.cpf.model.QueryPaging#getQueryHql()
   */
  @Override
  protected String getQueryHql()
  {
    String hql = "from SoggettoSogei s "
        + "where s.codice = :id ";
    return hql;
  }

  /* (non-Javadoc)
   * @see it.laitspa.cpf.model.QueryPaging#setQueryArguments(org.hibernate.Query)
   */
  @Override
  protected void setQueryArguments(Query q)
  {
    String[] named_params = q.getNamedParameters();
    for(int i = 0; i < named_params.length; ++i)
    {
      String param = named_params[i];

      if(param.equals("codiceFiscale"))
        q.setParameter("codiceFiscale", "%" + codiceFiscale.toUpperCase() + "%");
      else if(param.equals("codiceIpa"))
        q.setParameter("codiceIpa", codiceIpa);
      else if(param.equals("cognome"))
        q.setParameter("cognome", "%" + cognome.toUpperCase() + "%");
      else if(param.equals("denominazione"))
        q.setParameter("denominazione", "%" + denominazione.toUpperCase() + "%");
      else if(param.equals("identificativoFiscale"))
        q.setParameter("identificativoFiscale", "%" + identificativoFiscale.toUpperCase() + "%");
      else if(param.equals("nome"))
        q.setParameter("nome", "%" + nome.toUpperCase() + "%");      
    }
  }

}
