/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.model.sogei.sconto;

import it.laitspa.cpf.model.Entity;
import it.laitspa.cpf.model.sogei.fattura.FatturaSogei;
import it.laitspa.cpf.model.sogei.riga.RigaFatturaSogei;
import it.laitspa.cpf.model.sogei.tiposconto.TipoScontoSogei;

import java.math.BigDecimal;

import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

/**
 * @author andrea
 * 
 */
@javax.persistence.Entity
@Table(name = "TAB_SAN_CPF_SOGEI_SCNTFATT")
public class ScontoSogei
  extends Entity
{
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  @Id
  @GeneratedValue(generator = "sdi_gen_scnt", strategy = GenerationType.SEQUENCE)
  @SequenceGenerator(name = "sdi_gen_scnt", sequenceName = "SEQ_SAN_CPF_SOGEI_SCNTFATT",
      allocationSize = 1)
  @Column(name = "CODI_SCNT", nullable = false)
  private Integer           codice;

  @Column(name = "NUME_IMPT")
  private BigDecimal        importo;

  @Column(name = "NUME_IMPT_ALIQ")
  private BigDecimal        importoAliquota;

  @ManyToOne(targetEntity = TipoScontoSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_TIPO_SCNT", nullable = false)
  private TipoScontoSogei   tipoSconto;

  @ManyToOne(targetEntity = FatturaSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_FATT_SOGE")
  private FatturaSogei      fattura;

  @ManyToOne(targetEntity = RigaFatturaSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_RIGA_SOGE")
  private RigaFatturaSogei  riga;

  public Integer getCodice()
  {
    return codice;
  }

  public void setCodice(Integer codice)
  {
    this.codice = codice;
  }

  public BigDecimal getImporto()
  {
    return importo;
  }

  public void setImporto(BigDecimal importo)
  {
    this.importo = importo;
  }

  public BigDecimal getImportoAliquota()
  {
    return importoAliquota;
  }

  public void setImportoAliquota(BigDecimal importoAliquota)
  {
    this.importoAliquota = importoAliquota;
  }

  public TipoScontoSogei getTipoSconto()
  {
    return tipoSconto;
  }

  public void setTipoSconto(TipoScontoSogei tipoSconto)
  {
    this.tipoSconto = tipoSconto;
  }

  public FatturaSogei getFattura()
  {
    return fattura;
  }

  public void setFattura(FatturaSogei fattura)
  {
    this.fattura = fattura;
  }

  public RigaFatturaSogei getRiga()
  {
    return riga;
  }

  public void setRiga(RigaFatturaSogei riga)
  {
    this.riga = riga;
  }

}
