/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.model.sogei.ritenuta;

import it.laitspa.cpf.model.Entity;
import it.laitspa.cpf.model.sogei.fattura.FatturaSogei;
import it.laitspa.cpf.model.sogei.tiporitenuta.TipoRitenutaSogei;

import java.math.BigDecimal;

import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

/**
 * @author andrea
 * 
 */
@javax.persistence.Entity
@Table(name = "TAB_SAN_CPF_SOGEI_RITEFATT")
public class RitenutaSogei
  extends Entity
{
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  @Id
  @GeneratedValue(generator = "sdi_gen_rit", strategy = GenerationType.SEQUENCE)
  @SequenceGenerator(name = "sdi_gen_rit", sequenceName = "SEQ_SAN_CPF_SOGEI_RITEFATT",
      allocationSize = 1)
  @Column(name = "CODI_RITE_FATT", nullable = false)
  private Integer           codice;

  @Column(name = "NUME_IMPT_RITE")
  private BigDecimal        importoRitenuta;

  @Column(name = "NUME_IMPT_ALIQ")
  private BigDecimal        importoAliquota;

  @Column(name = "DESC_CAUS", length = 50)
  private String            causale;

  @ManyToOne(targetEntity = TipoRitenutaSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_TIPO_RITE", nullable = false)
  private TipoRitenutaSogei tipoRitenuta;

  @ManyToOne(targetEntity = FatturaSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_FATT_SOGE", nullable = false)
  private FatturaSogei      fattura;

  public Integer getCodice()
  {
    return codice;
  }

  public void setCodice(Integer codice)
  {
    this.codice = codice;
  }

  public BigDecimal getImportoRitenuta()
  {
    return importoRitenuta;
  }

  public void setImportoRitenuta(BigDecimal importoRitenuta)
  {
    this.importoRitenuta = importoRitenuta;
  }

  public BigDecimal getImportoAliquota()
  {
    return importoAliquota;
  }

  public void setImportoAliquota(BigDecimal importoAliquota)
  {
    this.importoAliquota = importoAliquota;
  }

  public String getCausale()
  {
    return causale;
  }

  public void setCausale(String causale)
  {
    this.causale = causale;
  }

  public TipoRitenutaSogei getTipoRitenuta()
  {
    return tipoRitenuta;
  }

  public void setTipoRitenuta(TipoRitenutaSogei tipoRitenuta)
  {
    this.tipoRitenuta = tipoRitenuta;
  }

  public FatturaSogei getFattura()
  {
    return fattura;
  }

  public void setFattura(FatturaSogei fattura)
  {
    this.fattura = fattura;
  }

}
