/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.model.sogei.riferimentolinea;

import it.laitspa.cpf.model.Entity;
import it.laitspa.cpf.model.sogei.riferimentodocumento.RiferimentoDocumentoSogei;

import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

/**
 * @author andrea
 * 
 */
@javax.persistence.Entity
@Table(name = "TAB_SAN_CPF_SOGEI_FATT_RFLN")
public class RiferimentoLineaDocumentoSogei
  extends Entity
{
  /**
   * 
   */
  private static final long         serialVersionUID = 1L;

  @Id
  @GeneratedValue(generator = "sdi_gen_rfld", strategy = GenerationType.SEQUENCE)
  @SequenceGenerator(name = "sdi_gen_rfld", sequenceName = "SEQ_SAN_CPF_SOGEI_FATT_RFLN",
      allocationSize = 1)
  @Column(name = "CODI_FATT_RFLN", nullable = false)
  private Integer                   codice;

  @Column(name = "NUME_RIFE_LINE", length = 50)
  private Integer                   riferimentoLineaDocumento;

  @ManyToOne(targetEntity = RiferimentoDocumentoSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_FATT_RIFE", nullable = false)
  private RiferimentoDocumentoSogei riferimentoDocumento;

  public Integer getCodice()
  {
    return codice;
  }

  public void setCodice(Integer codice)
  {
    this.codice = codice;
  }

  public Integer getRiferimentoLineaDocumento()
  {
    return riferimentoLineaDocumento;
  }

  public void setRiferimentoLineaDocumento(Integer riferimentoLineaDocumento)
  {
    this.riferimentoLineaDocumento = riferimentoLineaDocumento;
  }

  public RiferimentoDocumentoSogei getRiferimentoDocumento()
  {
    return riferimentoDocumento;
  }

  public void setRiferimentoDocumento(RiferimentoDocumentoSogei riferimentoDocumento)
  {
    this.riferimentoDocumento = riferimentoDocumento;
  }

}
