/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.model.sogei.riferimentodocumento;

import it.laitspa.cpf.model.Entity;
import it.laitspa.cpf.model.sogei.fattura.FatturaSogei;
import it.laitspa.cpf.model.sogei.tiporiferimentodocumento.TipoRiferimentoDocumentoSogei;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * @author andrea
 * 
 */
@javax.persistence.Entity
@Table(name = "TAB_SAN_CPF_SOGEI_FATT_RIFDOC")
public class RiferimentoDocumentoSogei
  extends Entity
{
  /**
   * 
   */
  private static final long             serialVersionUID = 1L;

  @Id
  @GeneratedValue(generator = "sdi_gen_rfd", strategy = GenerationType.SEQUENCE)
  @SequenceGenerator(name = "sdi_gen_rfd", sequenceName = "SEQ_SAN_CPF_SOGEI_FATT_RIFDOC",
      allocationSize = 1)
  @Column(name = "CODI_FATT_RIFE", nullable = false)
  private Integer                       codice;

  @Column(name = "DESC_NUME_DOCU", length = 50)
  private String                        numeroDocumento;

  @Temporal(TemporalType.DATE)
  @Column(name = "DATA_DOCU")
  private Date                          dataDocumento;

  @Column(name = "DESC_NUME_ITEM", length = 50)
  private String                        numeroLineaDocumento;

  @Column(name = "DESC_COMM_CONV", length = 100)
  private String                        codiceCommessaConvenzione;

  @Column(name = "DESC_NUME_CCUP", length = 20)
  private String                        numeroCup;

  @Column(name = "DESC_NUME_CCIG", length = 20)
  private String                        numeroCig;

  @Column(name = "NUME_RIFE_FASE")
  private Integer                       riferimentoFase;

  @ManyToOne(targetEntity = TipoRiferimentoDocumentoSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_TIPO_RIFE", nullable = false)
  private TipoRiferimentoDocumentoSogei tipoRiferimento;

  @ManyToOne(targetEntity = FatturaSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_FATT_SOGE", nullable = false)
  private FatturaSogei                  fattura;

  public Integer getCodice()
  {
    return codice;
  }

  public void setCodice(Integer codice)
  {
    this.codice = codice;
  }

  public String getNumeroDocumento()
  {
    return numeroDocumento;
  }

  public void setNumeroDocumento(String numeroDocumento)
  {
    this.numeroDocumento = numeroDocumento;
  }

  public Date getDataDocumento()
  {
    return dataDocumento;
  }

  public void setDataDocumento(Date dataDocumento)
  {
    this.dataDocumento = dataDocumento;
  }

  public String getNumeroLineaDocumento()
  {
    return numeroLineaDocumento;
  }

  public void setNumeroLineaDocumento(String numeroLineaDocumento)
  {
    this.numeroLineaDocumento = numeroLineaDocumento;
  }

  public String getCodiceCommessaConvenzione()
  {
    return codiceCommessaConvenzione;
  }

  public void setCodiceCommessaConvenzione(String codiceCommessaConvenzione)
  {
    this.codiceCommessaConvenzione = codiceCommessaConvenzione;
  }

  public String getNumeroCup()
  {
    return numeroCup;
  }

  public void setNumeroCup(String numeroCup)
  {
    this.numeroCup = numeroCup;
  }

  public String getNumeroCig()
  {
    return numeroCig;
  }

  public void setNumeroCig(String numeroCig)
  {
    this.numeroCig = numeroCig;
  }

  public Integer getRiferimentoFase()
  {
    return riferimentoFase;
  }

  public void setRiferimentoFase(Integer riferimentoFase)
  {
    this.riferimentoFase = riferimentoFase;
  }

  public TipoRiferimentoDocumentoSogei getTipoRiferimento()
  {
    return tipoRiferimento;
  }

  public void setTipoRiferimento(TipoRiferimentoDocumentoSogei tipoRiferimento)
  {
    this.tipoRiferimento = tipoRiferimento;
  }

  public FatturaSogei getFattura()
  {
    return fattura;
  }

  public void setFattura(FatturaSogei fattura)
  {
    this.fattura = fattura;
  }

}
