/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.model.sogei.riepilogo;

import it.laitspa.cpf.model.Entity;
import it.laitspa.cpf.model.sogei.fattura.FatturaSogei;
import it.laitspa.cpf.model.sogei.tiponatura.TipoNaturaSogei;

import java.math.BigDecimal;

import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

/**
 * @author andrea
 * 
 */
@javax.persistence.Entity
@Table(name = "TAB_SAN_CPF_SOGEI_FATT_RPLG")
public class RiepilogoFatturaSogei
  extends Entity
{
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  @Id
  @GeneratedValue(generator = "sdi_gen_rpg", strategy = GenerationType.SEQUENCE)
  @SequenceGenerator(name = "sdi_gen_rpg", sequenceName = "SEQ_SAN_CPF_SOGEI_FATT_RPLG",
      allocationSize = 1)
  @Column(name = "CODI_FATT_RPLG", nullable = false)
  private Integer           codice;

  @Column(name = "NUME_ALIQ")
  private BigDecimal        importoAliquota;

  @Column(name = "NUME_SPES_ACCE")
  private BigDecimal        importoSpeseAccessorie;

  @Column(name = "NUME_ARRO")
  private BigDecimal        importoArrotondamento;

  @Column(name = "NUME_IMPN")
  private BigDecimal        importoImponibile;

  @Column(name = "NUME_IMPT_TASS")
  private BigDecimal        importoImposta;

  @Column(name = "DESC_ESIG_IIVA", length = 1)
  private String            tipoEsigibilita;

  @Column(name = "DESC_RIFE_NORM", length = 100)
  private String            riferimentoNormativo;

  @ManyToOne(targetEntity = TipoNaturaSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_TIPO_NATU")
  private TipoNaturaSogei   tipoNatura;

  @ManyToOne(targetEntity = FatturaSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_FATT_SOGE", nullable = false)
  private FatturaSogei      fattura;

  public Integer getCodice()
  {
    return codice;
  }

  public void setCodice(Integer codice)
  {
    this.codice = codice;
  }

  public BigDecimal getImportoAliquota()
  {
    return importoAliquota;
  }

  public void setImportoAliquota(BigDecimal importoAliquota)
  {
    this.importoAliquota = importoAliquota;
  }

  public BigDecimal getImportoSpeseAccessorie()
  {
    return importoSpeseAccessorie;
  }

  public void setImportoSpeseAccessorie(BigDecimal importoSpeseAccessorie)
  {
    this.importoSpeseAccessorie = importoSpeseAccessorie;
  }

  public BigDecimal getImportoArrotondamento()
  {
    return importoArrotondamento;
  }

  public void setImportoArrotondamento(BigDecimal importoArrotondamento)
  {
    this.importoArrotondamento = importoArrotondamento;
  }

  public BigDecimal getImportoImponibile()
  {
    return importoImponibile;
  }

  public void setImportoImponibile(BigDecimal importoImponibile)
  {
    this.importoImponibile = importoImponibile;
  }

  public BigDecimal getImportoImposta()
  {
    return importoImposta;
  }

  public void setImportoImposta(BigDecimal importoImposta)
  {
    this.importoImposta = importoImposta;
  }

  public String getTipoEsigibilita()
  {
    return tipoEsigibilita;
  }

  public void setTipoEsigibilita(String tipoEsigibilita)
  {
    this.tipoEsigibilita = tipoEsigibilita;
  }

  public String getRiferimentoNormativo()
  {
    return riferimentoNormativo;
  }

  public void setRiferimentoNormativo(String riferimentoNormativo)
  {
    this.riferimentoNormativo = riferimentoNormativo;
  }

  public TipoNaturaSogei getTipoNatura()
  {
    return tipoNatura;
  }

  public void setTipoNatura(TipoNaturaSogei tipoNatura)
  {
    this.tipoNatura = tipoNatura;
  }

  public FatturaSogei getFattura()
  {
    return fattura;
  }

  public void setFattura(FatturaSogei fattura)
  {
    this.fattura = fattura;
  }

}
