/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.model.sogei.notifica;

import it.laitspa.cpf.model.Entity;
import it.laitspa.cpf.model.sogei.fattura.FatturaSogei;
import it.laitspa.cpf.model.sogei.inviofilesdi.InvioFileSdiSogei;
import it.laitspa.cpf.model.sogei.statonotifica.StatoNotificaSogei;
import it.laitspa.cpf.model.sogei.tiponotifica.TipoNotificaSogei;

import java.math.BigInteger;
import java.util.Date;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Type;

/**
 * @author andrea
 * 
 */
@javax.persistence.Entity
@Table(name = "TAB_SAN_CPF_SOGEI_NOTIFICA")
public class NotificaSogei
  extends Entity
{
  /**
   * 
   */
  private static final long  serialVersionUID = 1L;

  @Id
  @GeneratedValue(generator = "sdi_noti_gen", strategy = GenerationType.SEQUENCE)
  @SequenceGenerator(name = "sdi_noti_gen", sequenceName = "SEQ_SAN_CPF_SOGEI_NOTIFICA",
      allocationSize = 1)
  @Column(name = "CODI_NOTI", nullable = false)
  private Integer            codice;

  @Temporal(TemporalType.TIMESTAMP)
  @Column(name = "DATA_CREA", nullable = false)
  private Date               dataCreazione    = new Date();

  @Column(name = "DESC_FILE")
  private String             nomeFile;

  @Column(name = "IDEN_MESS")
  private BigInteger         identificativo;

  @Column(name = "DESC_NOTE")
  private String             note;

  @Column(name = "DESC_TEXT")
  private String             descrizione;

  @ManyToOne(targetEntity = StatoNotificaSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_STAT_NOTI", nullable = false)
  private StatoNotificaSogei statoNotifica;

  @ManyToOne(targetEntity = TipoNotificaSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_TIPO_NOTI", nullable = false)
  private TipoNotificaSogei  tipoNotifica;

  @ManyToOne(targetEntity = InvioFileSdiSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_INVI", nullable = false)
  private InvioFileSdiSogei  invio;

  @ManyToMany(targetEntity = FatturaSogei.class, fetch = FetchType.LAZY)
  @JoinTable(name = "TAB_SAN_CPF_SOGEI_NOTIFATT",
      joinColumns = { @JoinColumn(name = "CODI_NOTI") }, inverseJoinColumns = { @JoinColumn(
          name = "CODI_FATT_SOGE") })
  @Cascade(CascadeType.SAVE_UPDATE)
  private Set<FatturaSogei>  fatture;

  @Column(name = "NUME_PROG")
  private Integer            progressivo;

  @Temporal(TemporalType.TIMESTAMP)
  @Column(name = "DATA_ELAB")
  private Date               dataElaborazione;

  @Type(type = "yes_no")
  @Column(name = "FLAG_ESIT")
  private Boolean            flagEsito;
  
  @OneToOne(targetEntity=AllegatoNotificaSogei.class, mappedBy="notifica")
  private AllegatoNotificaSogei allegato;

  public Integer getCodice()
  {
    return codice;
  }

  public void setCodice(Integer codice)
  {
    this.codice = codice;
  }

  public Date getDataCreazione()
  {
    return dataCreazione;
  }

  public void setDataCreazione(Date dataCreazione)
  {
    this.dataCreazione = dataCreazione;
  }

  public String getNomeFile()
  {
    return nomeFile;
  }

  public void setNomeFile(String nomeFile)
  {
    this.nomeFile = nomeFile;
  }

  public BigInteger getIdentificativo()
  {
    return identificativo;
  }

  public void setIdentificativo(BigInteger identificativo)
  {
    this.identificativo = identificativo;
  }

  public String getNote()
  {
    return note;
  }

  public void setNote(String note)
  {
    this.note = note;
  }

  public String getDescrizione()
  {
    return descrizione;
  }

  public void setDescrizione(String descrizione)
  {
    this.descrizione = descrizione;
  }

  public StatoNotificaSogei getStatoNotifica()
  {
    return statoNotifica;
  }

  public void setStatoNotifica(StatoNotificaSogei statoNotifica)
  {
    this.statoNotifica = statoNotifica;
  }

  public TipoNotificaSogei getTipoNotifica()
  {
    return tipoNotifica;
  }

  public void setTipoNotifica(TipoNotificaSogei tipoNotifica)
  {
    this.tipoNotifica = tipoNotifica;
  }

  public InvioFileSdiSogei getInvio()
  {
    return invio;
  }

  public void setInvio(InvioFileSdiSogei invio)
  {
    this.invio = invio;
  }

  public Set<FatturaSogei> getFatture()
  {
    return fatture;
  }

  public void setFatture(Set<FatturaSogei> fatture)
  {
    this.fatture = fatture;
  }

  public Integer getProgressivo()
  {
    return progressivo;
  }

  public void setProgressivo(Integer progressivo)
  {
    this.progressivo = progressivo;
  }

  public Date getDataElaborazione()
  {
    return dataElaborazione;
  }

  public void setDataElaborazione(Date dataElaborazione)
  {
    this.dataElaborazione = dataElaborazione;
  }

  public Boolean getFlagEsito()
  {
    return flagEsito;
  }

  public void setFlagEsito(Boolean flagEsito)
  {
    this.flagEsito = flagEsito;
  }

  public AllegatoNotificaSogei getAllegato()
  {
    return allegato;
  }

  public void setAllegato(AllegatoNotificaSogei allegato)
  {
    this.allegato = allegato;
  }

}
