/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.model.sogei.notifica;

import it.laitspa.cpf.model.Entity;

import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

/**
 * @author andrea
 * 
 */
@javax.persistence.Entity
@Table(name = "TAB_SAN_CPF_SOGEI_OBJTNOTI")
public class AllegatoNotificaSogei
  extends Entity
{
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  @Id
  @GeneratedValue(generator = "sdi_notiall_gen", strategy = GenerationType.SEQUENCE)
  @SequenceGenerator(name = "sdi_notiall_gen", sequenceName = "SEQ_SAN_CPF_SOGEI_OBJTNOTI",
      allocationSize = 1)
  @Column(name = "CODI_OBJT_NOTI", nullable = false)
  private Integer           codice;

  @Lob
  @Column(name = "OBJT_NOTI", nullable = false)
  private byte[]            request;

  @Lob
  @Column(name = "OBJT_NOTI_RESP")
  private byte[]            response;

  @OneToOne(targetEntity = NotificaSogei.class, fetch = FetchType.EAGER)
  @JoinColumn(name = "CODI_NOTI", nullable = false)
  private NotificaSogei     notifica;

  public Integer getCodice()
  {
    return codice;
  }

  public void setCodice(Integer codice)
  {
    this.codice = codice;
  }

  public NotificaSogei getNotifica()
  {
    return notifica;
  }

  public void setNotifica(NotificaSogei notifica)
  {
    this.notifica = notifica;
  }

  public byte[] getRequest()
  {
    return request;
  }

  public void setRequest(byte[] request)
  {
    this.request = request;
  }

  public byte[] getResponse()
  {
    return response;
  }

  public void setResponse(byte[] response)
  {
    this.response = response;
  }

}
