/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.model.sogei.inviofilesdi;

import it.laitspa.cpf.model.Entity;
import it.laitspa.cpf.model.sogei.statoinvio.StatoInvioSogei;

import java.math.BigInteger;
import java.util.Date;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.hibernate.annotations.Type;

/**
 * @author andrea
 * 
 */
@javax.persistence.Entity
@Table(name = "TAB_SAN_CPF_SOGEI_INVIOFILE")
public class InvioFileSdiSogei
  extends Entity
{
  /**
   * 
   */
  private static final long              serialVersionUID = 1L;

  @Id
  @GeneratedValue(generator = "sdi_file_gen", strategy = GenerationType.SEQUENCE)
  @SequenceGenerator(name = "sdi_file_gen", sequenceName = "SEQ_SAN_CPF_SOGEI_INVIOFILE",
      allocationSize = 1)
  @Column(name = "CODI_INVI", nullable = false)
  private Integer                        codice;
  @Column(name = "CODI_DEST", nullable = false)
  private String                         codiceDestinatario;

  @Column(name = "CODI_IDEN")
  private BigInteger                     identificativo;

  @Column(name = "CODI_IDEN_META")
  private BigInteger                     identificativoMetadati;

  @Temporal(TemporalType.TIMESTAMP)
  @Column(name = "DATA_CREA", nullable = false)
  private Date                           dataCreazione    = new Date();

  @Column(name = "PRES_CEDE")
  private String                         prestatoreCedente;
  @Column(name = "CESS_EMIT")
  private String                         cessionarioCommittente;
  @Column(name = "DESC_FILE")
  private String                         nomeFile;
  @Column(name = "DESC_FILE_META")
  private String                         nomeFileMetadati;

  @OneToMany(targetEntity = AllegatoInvioFileSdiSogei.class, fetch = FetchType.LAZY,
      mappedBy = "file")
  private Set<AllegatoInvioFileSdiSogei> allegati;

  @Temporal(TemporalType.TIMESTAMP)
  @Column(name = "DATA_ELAB")
  private Date                           dataElaborazione;

  @Type(type = "yes_no")
  @Column(name = "FLAG_ESIT")
  private Boolean                        flagEsito;

  @Temporal(TemporalType.TIMESTAMP)
  @Column(name = "DATA_RICE")
  private Date                           dataRicezione;

  @ManyToOne(targetEntity = StatoInvioSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_STAT", nullable = false)
  private StatoInvioSogei                statoInvio;

  @Column(name = "NUME_PROG")
  private Integer                        progressivo;

  public Integer getCodice()
  {
    return codice;
  }

  public void setCodice(Integer codice)
  {
    this.codice = codice;
  }

  public String getCodiceDestinatario()
  {
    return codiceDestinatario;
  }

  public void setCodiceDestinatario(String codiceDestinatario)
  {
    this.codiceDestinatario = codiceDestinatario;
  }

  public BigInteger getIdentificativo()
  {
    return identificativo;
  }

  public void setIdentificativo(BigInteger identificativo)
  {
    this.identificativo = identificativo;
  }

  public Date getDataCreazione()
  {
    return dataCreazione;
  }

  public void setDataCreazione(Date dataCreazione)
  {
    this.dataCreazione = dataCreazione;
  }

  public String getPrestatoreCedente()
  {
    return prestatoreCedente;
  }

  public void setPrestatoreCedente(String prestatoreCedente)
  {
    this.prestatoreCedente = prestatoreCedente;
  }

  public String getCessionarioCommittente()
  {
    return cessionarioCommittente;
  }

  public void setCessionarioCommittente(String cessionarioCommittente)
  {
    this.cessionarioCommittente = cessionarioCommittente;
  }

  public String getNomeFile()
  {
    return nomeFile;
  }

  public void setNomeFile(String nomeFile)
  {
    this.nomeFile = nomeFile;
  }

  public String getNomeFileMetadati()
  {
    return nomeFileMetadati;
  }

  public void setNomeFileMetadati(String nomeFileMetadati)
  {
    this.nomeFileMetadati = nomeFileMetadati;
  }

  public BigInteger getIdentificativoMetadati()
  {
    return identificativoMetadati;
  }

  public void setIdentificativoMetadati(BigInteger identificativoMetadati)
  {
    this.identificativoMetadati = identificativoMetadati;
  }

  public Set<AllegatoInvioFileSdiSogei> getAllegati()
  {
    return allegati;
  }

  public void setAllegati(Set<AllegatoInvioFileSdiSogei> allegati)
  {
    this.allegati = allegati;
  }

  public Date getDataElaborazione()
  {
    return dataElaborazione;
  }

  public void setDataElaborazione(Date dataElaborazione)
  {
    this.dataElaborazione = dataElaborazione;
  }

  public Boolean getFlagEsito()
  {
    return flagEsito;
  }

  public void setFlagEsito(Boolean flagEsito)
  {
    this.flagEsito = flagEsito;
  }

  public Date getDataRicezione()
  {
    return dataRicezione;
  }

  public void setDataRicezione(Date dataRicezione)
  {
    this.dataRicezione = dataRicezione;
  }

  public StatoInvioSogei getStatoInvio()
  {
    return statoInvio;
  }

  public void setStatoInvio(StatoInvioSogei statoInvio)
  {
    this.statoInvio = statoInvio;
  }

  public Integer getProgressivo()
  {
    return progressivo;
  }

  public void setProgressivo(Integer progressivo)
  {
    this.progressivo = progressivo;
  }

}
