/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.model.sogei.fattura;

import it.laitspa.cpf.model.QueryPaging;

import java.util.Date;

import org.hibernate.Query;
import org.hibernate.Session;

/**
 * @author andrea
 * 
 */
public class QueryFsByEmittente
  extends QueryPaging
{

  private Date    dataCaricamentoDa;
  private Date    dataCaricamentoA;
  private String  partitaIvaCedente;
  private String  partitaIvaCommittente;
  private String  codiceIpa;

  private Integer codiceEmittente;
  
  private Integer codiceStato;
  
  private String  numeroFattura;
  private Date    dataFatturaDa;
  private Date    dataFatturaA;

  public QueryFsByEmittente(Session session)
  {
    super(session);
  }

  public Date getDataFatturaDa()
  {
    return dataFatturaDa;
  }

  public void setDataFatturaDa(Date dataFatturaDa)
  {
    this.dataFatturaDa = dataFatturaDa;
  }

  public Date getDataFatturaA()
  {
    return dataFatturaA;
  }

  public void setDataFatturaA(Date dataFatturaA)
  {
    this.dataFatturaA = dataFatturaA;
  }

  public String getNumeroFattura()
  {
    return numeroFattura;
  }

  public void setNumeroFattura(String numeroFattura)
  {
    this.numeroFattura = numeroFattura;
  }

  public Integer getCodiceStato()
  {
    return codiceStato;
  }

  public void setCodiceStato(Integer codiceStato)
  {
    this.codiceStato = codiceStato;
  }

  public String getCodiceIpa()
  {
    return codiceIpa;
  }

  public void setCodiceIpa(String codiceIpa)
  {
    this.codiceIpa = codiceIpa;
  }

  public Date getDataCaricamentoDa()
  {
    return dataCaricamentoDa;
  }

  public void setDataCaricamentoDa(Date dataCaricamentoDa)
  {
    this.dataCaricamentoDa = dataCaricamentoDa;
  }

  public Date getDataCaricamentoA()
  {
    return dataCaricamentoA;
  }

  public void setDataCaricamentoA(Date dataCaricamentoA)
  {
    this.dataCaricamentoA = dataCaricamentoA;
  }

  public String getPartitaIvaCedente()
  {
    return partitaIvaCedente;
  }

  public void setPartitaIvaCedente(String partitaIvaCedente)
  {
    this.partitaIvaCedente = partitaIvaCedente;
  }

  public String getPartitaIvaCommittente()
  {
    return partitaIvaCommittente;
  }

  public void setPartitaIvaCommittente(String partitaIvaCommittente)
  {
    this.partitaIvaCommittente = partitaIvaCommittente;
  }

  public Integer getCodiceEmittente()
  {
    return codiceEmittente;
  }

  public void setCodiceEmittente(Integer codiceEmittente)
  {
    this.codiceEmittente = codiceEmittente;
  }

  /*
   * (non-Javadoc)
   * 
   * @see it.laitspa.cpf.model.QueryPaging#checkQueryArguments()
   */
  @Override
  protected boolean checkQueryArguments()
  {
    return true;
  }

  /*
   * (non-Javadoc)
   * 
   * @see it.laitspa.cpf.model.QueryPaging#getListHql()
   */
  @Override
  protected String getListHql()
  {
    String hql =
        "select distinct a.codice "
            + "from FatturaSogei a "
            + "inner join a.datiTrasmissione tr "; 
    
    if (codiceEmittente != null)
    {
      hql += "left join tr.soggettoCedente str left join tr.soggettoCessionario str2 ";
    }
    
    if (partitaIvaCedente != null)
      hql += "left join tr.cedente ced left join ced.anagrafica aced "; 
    
    if (partitaIvaCommittente != null)
      hql += "left join tr.cessionario ces left join ces.anagrafica aces ";  
    
    if (codiceStato != null)
      hql += "inner join a.stato stf ";
    

    boolean firstArg = true;

    if(codiceEmittente != null)
    {
      if(firstArg)
      {
        hql += "where ";
        firstArg = false;
      }
      else
        hql += "and ";
      hql += "((str.codice is not null and str.codice = :codiceEmittente) or (str2.codice is not null and str2.codice = :codiceEmittente)) ";
    }
    
    if(codiceIpa != null)
    {
      if(firstArg)
      {
        hql += "where ";
        firstArg = false;
      }
      else
        hql += "and ";
      hql += "tr.codiceDestinatario = :codiceIpa ";
    }

    if(dataCaricamentoDa != null)
    {
      if(firstArg)
      {
        hql += "where ";
        firstArg = false;
      }
      else
        hql += "and ";
      hql += "tr.dataCreazione >= :dataCaricamentoDa ";
    }

    if(dataCaricamentoA != null)
    {
      if(firstArg)
      {
        hql += "where ";
        firstArg = false;
      }
      else
        hql += "and ";
      hql += "tr.dataCreazione < :dataCaricamentoA ";
    }

    if(partitaIvaCedente != null)
    {
      if(firstArg)
      {
        hql += "where ";
        firstArg = false;
      }
      else
        hql += "and ";
      hql += "aced.codiceIdentificativoFiscale = :partitaIvaCedente ";
    }

    if(partitaIvaCommittente != null)
    {
      if(firstArg)
      {
        hql += "where ";
        firstArg = false;
      }
      else
        hql += "and ";
      hql += "aces.codiceIdentificativoFiscale = :partitaIvaCommittente ";
    }
    
    if(codiceStato != null)
    {
      if(firstArg)
      {
        hql += "where ";
        firstArg = false;
      }
      else
        hql += "and ";
      hql += "stf.codice = :codiceStato ";
    }

    if(dataFatturaDa != null)
    {
      if(firstArg)
      {
        hql += "where ";
        firstArg = false;
      }
      else
        hql += "and ";
      hql += "a.dataFattura >= :dataFatturaDa ";
    }

    if(dataFatturaA != null)
    {
      if(firstArg)
      {
        hql += "where ";
        firstArg = false;
      }
      else
        hql += "and ";
      hql += "a.dataFattura < :dataFatturaA ";
    } 
    
    if(numeroFattura != null)
    {
      if(firstArg)
      {
        hql += "where ";
        firstArg = false;
      }
      else
        hql += "and ";
      hql += "upper(a.numeroFattura) like :numeroFattura ";
    }      
    
    hql += "order by a.codice desc";

    return hql;
  }

  /*
   * (non-Javadoc)
   * 
   * @see it.laitspa.cpf.model.QueryPaging#getQueryHql()
   */
  @Override
  protected String getQueryHql()
  {
    String hql =
            "select a "
            + "from FatturaSogei a "
            + "left join fetch a.tipoFattura tpf "
            + "left join fetch a.stato st "
            + "left join fetch a.datiTrasmissione dt "
            + "left join fetch dt.soggettoCessionario sdt "
            + "left join fetch dt.cedente ced "
            + "left join fetch ced.anagrafica aced "
            + "left join fetch dt.cessionario ces "
            + "left join fetch ces.anagrafica aces "
            + "where a.codice = :id ";
    return hql;
  }

  /*
   * (non-Javadoc)
   * 
   * @see
   * it.laitspa.cpf.model.QueryPaging#setQueryArguments(org.hibernate.Query)
   */
  @Override
  protected void setQueryArguments(Query q)
  {
    String[] named_params = q.getNamedParameters();
    for(int i = 0; i < named_params.length; ++i)
    {
      String param = named_params[i];

      if(param.equals("codiceEmittente"))
        q.setParameter("codiceEmittente", codiceEmittente);
      else if(param.equals("dataCaricamentoDa"))
        q.setParameter("dataCaricamentoDa", dataCaricamentoDa);
      else if(param.equals("dataCaricamentoA"))
        q.setParameter("dataCaricamentoA", dataCaricamentoA);
      else if(param.equals("partitaIvaCedente"))
        q.setParameter("partitaIvaCedente", partitaIvaCedente);
      else if(param.equals("partitaIvaCommittente"))
        q.setParameter("partitaIvaCommittente", partitaIvaCommittente);
      else if(param.equals("codiceIpa"))
        q.setParameter("codiceIpa", codiceIpa);  
      else if(param.equals("codiceStato"))
        q.setParameter("codiceStato", codiceStato);       
      else if(param.equals("dataFatturaDa"))
          q.setParameter("dataFatturaDa", dataFatturaDa);        
      else if(param.equals("dataFatturaA"))
        q.setParameter("dataFatturaA", dataFatturaA);        
      else if(param.equals("numeroFattura"))
        q.setParameter("numeroFattura", "%" + numeroFattura.toUpperCase() + "%");
    }
  }
  
  @Override
  protected void setQueryId(Query q, Object id)
  {
    q.setParameter("id", id);
  }

}
