/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.model.sogei.fattura;

import org.hibernate.Query;
import org.hibernate.Session;

import it.laitspa.cpf.model.QueryPaging;

/**
 * @author andrea
 *
 */
public class QrFs
  extends QueryPaging
{

  public QrFs(Session session)
  {
    super(session);
  }

  /* (non-Javadoc)
   * @see it.laitspa.cpf.model.QueryPaging#checkQueryArguments()
   */
  @Override
  protected boolean checkQueryArguments()
  {
    return true;
  }

  /* (non-Javadoc)
   * @see it.laitspa.cpf.model.QueryPaging#getListHql()
   */
  @Override
  protected String getListHql()
  {
    String hql = "select distinct d.codice, "
        + "i.dataCreazione "
        + "from FatturaSogei d "
        + "inner join d.invio i "
        + "order by i.dataCreazione desc ";
    return hql;
  }

  /* (non-Javadoc)
   * @see it.laitspa.cpf.model.QueryPaging#getQueryHql()
   */
  @Override
  protected String getQueryHql()
  {
    String hql = "from FatturaSogei s "
        + "inner join fetch s.invio i "
        + "inner join fetch s.stato st "
        + "left join fetch s.fattura ft "
        + "where s.codice = :id";
    
    return hql;
  }

  /* (non-Javadoc)
   * @see it.laitspa.cpf.model.QueryPaging#setQueryArguments(org.hibernate.Query)
   */
  @Override
  protected void setQueryArguments(Query q)
  {
    
  }

}
