/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package it.laitspa.cpf.model;

/**
 *
 * @author Andrea
 */
import java.util.Map;

import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;

public abstract class SortableQuery
{
  private int       firstResult;
  private int       maxResults;

  protected Session session;
  protected Map<String, SortableProperty> sortableProperties;

  public SortableQuery(Session session)
  {
    firstResult = 0;
    maxResults = 10;
    this.session = session;
    this.sortableProperties = null;
  }

  public ScrollableResults scroll()
  {
    // Check query arguments.
    //
    if(!checkQueryArguments())
      throw new IllegalArgumentException();

    // Initialize hibernate session and query objects.
    //
    // Execute the query.
    //
    String queryHql = getQueryHql();
    queryHql += getOrderBy();
    org.hibernate.Query q = session.createQuery(queryHql);
    setQueryLimits(q);
    setQueryArguments(q);
    return q.scroll(ScrollMode.FORWARD_ONLY);
  }

  public QueryResult query()
  {
    // Check query arguments.
    //
    if(!checkQueryArguments())
      throw new IllegalArgumentException();

    // Initialize hibernate session and query objects.
    //
    QueryResult result = new QueryResult();
    org.hibernate.Query q;

    // Count the query results.
    //
    String countHql = getCountHql();
    q = session.createQuery(countHql);
    setQueryArguments(q);
    Object o = q.uniqueResult();

    int count = 0;
    if(o instanceof Integer)
      count = ((Integer)o).intValue();
    else if(o instanceof Long)
      count = ((Long)o).intValue();
    else
      throw new IllegalArgumentException("Unexpected type found when counting query.");

    result.setCount(count);

    // If no items will be returned by the query,
    // we spare the effort of querying.
    //
    if(count <= 0)
      return result;


    // Execute the query.
    //
    String queryHql = getQueryHql();
    queryHql += getOrderBy();
    q = session.createQuery(queryHql);
    setQueryLimits(q);
    setQueryArguments(q);
    result.setItems(q.list());

    // Return the results.
    //
    return result;
  }

  private void setQueryLimits(org.hibernate.Query q)
  {
    q.setFirstResult(firstResult);

    if(maxResults >= 0)
      q.setMaxResults(maxResults);
  }

  protected abstract boolean checkQueryArguments();

  protected abstract String getCountHql();

  protected abstract String getQueryHql();

  protected abstract void setQueryArguments(org.hibernate.Query q);
  
  protected abstract Map<String, SortableProperty> getSortableProperties();
  
  @SuppressWarnings({ "rawtypes", "unchecked" })
  public void setSortableProperties(Map orderCriteria)
  {
    // Force casting
    //
    Map<String, Boolean> properties = (Map<String, Boolean>) orderCriteria;

    if (sortableProperties == null)
      sortableProperties = getSortableProperties();
    
    if (sortableProperties == null 
        || sortableProperties.size() == 0
        || properties == null
        || properties.size() == 0)
      return;
    
    // Reset sort properties
    //
    unsetSortableProperties(); 
    
    for (String key : properties.keySet())
    {
      SortableProperty prop = sortableProperties.get(key);
      if (prop != null)
        prop.setAscending(properties.get(key));
    }
  }
  
  public String getOrderBy()
  {
    if (sortableProperties == null || sortableProperties.size() == 0)
      return "";
    
    // Build order by string.
    //
    String orderby = "";
    for (SortableProperty p : sortableProperties.values())
    {
      if (p.getAscending() == null)
        continue;
      
      if (orderby.trim().length() > 0)
        orderby += ", ";
      
      orderby += p.getName();
      
      if (!p.getAscending())
        orderby += " desc";
    }
    return orderby.trim().length() > 0 ? " order by " + orderby : "";
  }

  public int getFirstResult()
  {
    return firstResult;
  }

  public void setFirstResult(int firstResult)
  {
    this.firstResult = firstResult;
  }

  public int getMaxResults()
  {
    return maxResults;
  }

  public void setMaxResults(int maxResults)
  {
    this.maxResults = maxResults;
  }
  
  private void unsetSortableProperties()
  {
    if (sortableProperties == null)
      return;
    
    for (SortableProperty p : sortableProperties.values())
      p.setAscending(null);
  }
}

