/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
package it.laitspa.cpf.model;


import org.hibernate.Session;

public class QueryLutOrderBy
  extends Query
{
  private String lut;
  private String orderColumn;

  
  public String getLut()
  {
    return lut;
  }

  public void setLut(String lut)
  {
    this.lut = lut;
  }

  public String getOrderColumn()
  {
    return orderColumn;
  }

  public void setOrderColumn(String orderColumn)
  {
    this.orderColumn = orderColumn;
  }

  public QueryLutOrderBy(Session session)
  {
    super(session);
  }

  protected boolean checkQueryArguments()
  {
    if(lut == null)
      return false;
    
    return true;
  }

  protected String getCountHql()
  {
    String hql = 
      "select count(*) from " + lut;

    return hql;
  }

  protected String getQueryHql()
  {
    String hql = 
      "from " + lut + " lut ";

    if(orderColumn != null)
      hql += "order by lut." + orderColumn;
    
    return hql;
  }

  protected void setQueryArguments(org.hibernate.Query q)
  {
  }
}
