/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.job;

import java.io.Serializable;

import org.apache.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerContext;
import org.springframework.context.ApplicationContext;

/**
 * @author andrea
 * 
 */
public abstract class JobRunner
  implements Serializable
{

  /**
   * 
   */
  private static final long     serialVersionUID = 1L;

  protected Logger              logger;

  protected JobExecutionContext jec;

  public JobRunner(JobExecutionContext jec)
  {
    this.logger = Logger.getLogger(getClass());
    this.jec = jec;
  }

  public abstract void execute()
    throws JobExecutionException;

  @SuppressWarnings("unchecked")
  public <K> K findBean(Class<K> ifb)
  {
    K res = null;
    try
    {
      String name = ifb.getSimpleName();
      Scheduler scheduler = jec.getScheduler();
      SchedulerContext sContext = scheduler.getContext();
      ApplicationContext appContext = (ApplicationContext)sContext.get("applicationContext");
      res = (K)appContext.getBean(name);
      if(res == null)
      {
        String msg = "Unable to retrieve spring bean: " + name;
        logger.error(msg);
      }
    }
    catch(Exception e)
    {
      logger.error(e);
    }
    return res;
  }

}
