package it.laitspa.cpf.faces.utils.versionefattura;

import it.gov.fatturapa.sdi.fatturapa.v1.FormatoTrasmissioneType;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * Created by scipriani on 16/12/16.
 */
public class VersioneFatturaPaHelper {
    public static InputStream getFoglioDiStile(byte[] filexml) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.parse(new ByteArrayInputStream(filexml));
        String versione = document.getDocumentElement().getAttribute("versione");
        if(FormatoTrasmissioneType.FPA_12.value().equals(versione)){
            return VersioneFatturaPaHelper.class.getResourceAsStream("fatturapa_v1.2.xsl");
        }else if(FormatoTrasmissioneType.FPR_12.value().equals(versione)){
            return VersioneFatturaPaHelper.class.getResourceAsStream("fatturapa_v1.2.xsl");
        }else{
            return VersioneFatturaPaHelper.class.getResourceAsStream("fatturapa_v1.1.xsl");
        }
    }

    public static InputStream getFoglioDiStilePDF(byte[] filexml) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.parse(new ByteArrayInputStream(filexml));
        String versione = document.getDocumentElement().getAttribute("versione");
        if(FormatoTrasmissioneType.FPA_12.value().equals(versione)){
            return VersioneFatturaPaHelper.class.getResourceAsStream("fatturapapdf_v1.2.xsl");
        }else if(FormatoTrasmissioneType.FPR_12.value().equals(versione)){
            return VersioneFatturaPaHelper.class.getResourceAsStream("fatturapapdf_v1.2.xsl");
        }else{
            return VersioneFatturaPaHelper.class.getResourceAsStream("fatturapapdf_v1.1.xsl");
        }
    }

    public static InputStream getFileXSD(byte[] filexml) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.parse(new ByteArrayInputStream(filexml));
        String versione = document.getDocumentElement().getAttribute("versione");
        if(FormatoTrasmissioneType.FPA_12.value().equals(versione)){
            return VersioneFatturaPaHelper.class.getResourceAsStream("fatturapa_v1.2.xsd");
        }else if(FormatoTrasmissioneType.FPR_12.value().equals(versione)){
            return VersioneFatturaPaHelper.class.getResourceAsStream("fatturapa_v1.2.xsd");
        }else{
            return VersioneFatturaPaHelper.class.getResourceAsStream("fatturapa_v1.1.xsd");
        }

    }
}
