/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package it.laitspa.cpf.faces.utils.validator;

import it.laitspa.cpf.faces.BeanModel;

/**
 * 
 * @author Andrea
 */
public class ValidatorBean
  extends BeanModel
{

  /**
   * 
   */
  private static final long serialVersionUID            = 1L;


  private final String      REGEX_PHONE                 = "^(\\+){0,1}[0-9.-/ ]+$";
  private final String      REGEX_CAP                   = "^\\d{5}$";
  private final String      REGEX_DECIMAL               = "^[+-]{0,1}\\d+(\\,\\d*){0,1}$";
  private final String      REGEX_INTEGER               = "^[+-]{0,1}\\d+$";
  /**
   * Decimale con massimo tre cifre, un punto, e una cifra decimale opzionale
   */
  private final String      REGEX_DECIMAL13_1           = "^([0-9]|[1-9][0-9]{1}|[1-9][0-9]{2})(\\,[0-9]{1}){0,1}$";
  /**
   * Decimale con massimo sei cifre, un punto, e due cifra decimali opzionali
   */
  private final String      REGEX_DECIMAL16_2           = "^([0-9]|[1-9][0-9]{1}|[1-9][0-9]{2}|[1-9][0-9]{3}|[1-9][0-9]{4}|[1-9][0-9]{5})(\\,[0-9]{1}||[0-9]{2}){0,1}$";
  private final String      REGEX_EMAIL                 = "^([a-zA-Z0-9_\\-\\.]+)@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.)|(([a-zA-Z0-9\\-]+\\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\\]?)$";
  private final String      REGEX_PASSWORD              = "^(?=.*[a-zA-Z]+.*)(?=.*[0-9]+.*)[0-9a-zA-Z]{8,}$";
  private final String      REGEX_CODICELIBRETTO        = "^[a-zA-Z]{6}$";
  private final String      REGEX_SEZIONE               = "^\\w$";
  private final String      REGEX_CODICEREGIONALE       = "^\\d{6}$";

  /*
   * AmountUtils patterns
   */
  private final String      REGEX_ISVALID_AMOUNT        = "\\d+(,\\d{2}){0,1}";
  private final String      REGEX_ISVALID_SIGNED_AMOUNT = "[+-]{0,1}\\d+(,\\d{2}){0,1}";
  private final String      REGEX_ISVALID_PRICE         = "\\d+(,\\d{2,5}){0,1}";
  private final String      REGEX_ISVALID_SIGNED_PRICE  = "[+-]{0,1}\\d+(,\\d{2,5}){0,1}";
  private final String      REGEX_ISVALID_PERC          = "^(100|\\d{1,2}(,\\d{1,3}){0,1})$";
  private final String      REGEX_ISZERO                = "0(,0+){0,1}";

  private final String      REGEX_ISNULL                = "_NL_";

  public String getREGEX_ISNULL()
  {
    return REGEX_ISNULL;
  }

  public String getREGEX_ISVALID_AMOUNT()
  {
    return REGEX_ISVALID_AMOUNT;
  }

  public String getREGEX_ISVALID_PERC()
  {
    return REGEX_ISVALID_PERC;
  }

  public String getREGEX_ISVALID_PRICE()
  {
    return REGEX_ISVALID_PRICE;
  }

  public String getREGEX_ISVALID_SIGNED_AMOUNT()
  {
    return REGEX_ISVALID_SIGNED_AMOUNT;
  }

  public String getREGEX_ISVALID_SIGNED_PRICE()
  {
    return REGEX_ISVALID_SIGNED_PRICE;
  }

  public String getREGEX_ISZERO()
  {
    return REGEX_ISZERO;
  }

  public String getREGEX_CODICEREGIONALE()
  {
    return REGEX_CODICEREGIONALE;
  }

  public String getREGEX_CODICELIBRETTO()
  {
    return REGEX_CODICELIBRETTO;
  }

  public String getREGEX_DECIMAL()
  {
    return REGEX_DECIMAL;
  }

  public String getREGEX_DECIMAL13_1()
  {
    return REGEX_DECIMAL13_1;
  }

  public String getREGEX_DECIMAL16_2()
  {
    return REGEX_DECIMAL16_2;
  }

  public String getREGEX_EMAIL()
  {
    return REGEX_EMAIL;
  }

  public String getREGEX_INTEGER()
  {
    return REGEX_INTEGER;
  }

  public String getREGEX_PASSWORD()
  {
    return REGEX_PASSWORD;
  }

  public String getREGEX_SEZIONE()
  {
    return REGEX_SEZIONE;
  }

  public String getREGEX_CAP()
  {
    return REGEX_CAP;
  }

  public String getREGEX_PHONE()
  {
    return REGEX_PHONE;
  }

  /** Creates a new instance of ValidatorBean */
  public ValidatorBean()
  {
  }

  // Method prototype: public void <name>(FacesContext context, UIComponent
  // component, Object value)
  //
  //

}
