/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package it.laitspa.cpf.faces.utils.validator;

import it.laitspa.cpf.faces.utils.FacesUtils;
import it.laitspa.cpf.util.misc.FormUtils;

import javax.faces.component.UIComponent;

/**
 * 
 * @author Andrea
 */
public class PartitaIvaValidator
  extends CustomValidator
{
  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  public static final String PARTITAIVA_VALIDATORID = "PIVAVal";
  public static final Integer ITALIA = new Integer(111);

  private String             mustBeUnique;

  private Integer            codice;

  private String             componentStatoId;

  private String             componentTipoFornitoreId;

  private String             validatorType;

  public String getComponentTipoFornitoreId()
  {
    return componentTipoFornitoreId;
  }

  public void setComponentTipoFornitoreId(String componentTipoFornitoreId)
  {
    this.componentTipoFornitoreId = componentTipoFornitoreId;
  }

  public String getComponentStatoId()
  {
    return componentStatoId;
  }

  public void setComponentStatoId(String componentStatoId)
  {
    this.componentStatoId = componentStatoId;
  }

  public String getValidatorType()
  {
    return validatorType;
  }

  public void setValidatorType(String validatorType)
  {
    this.validatorType = validatorType;
  }

  public Integer getCodice()
  {
    return codice;
  }

  public void setCodice(Integer codice)
  {
    this.codice = codice;
  }

  public String getMustBeUnique()
  {
    return mustBeUnique;
  }

  public void setMustBeUnique(String mustBeUnique)
  {
    this.mustBeUnique = mustBeUnique;
  }

  @Override
  protected boolean isValidValue(String value)
  {
    if(FormUtils.isEmpty(value))
      return false;
    else
    {
      Integer codiceStato = null;
      if(componentStatoId != null)
      {
        UIComponent tipoStato = FacesUtils.findUIComponentById(componentStatoId);
        Object objValue = tipoStato.getAttributes().get("value");
        codiceStato = (Integer)objValue;
      }
      if(codiceStato == null || codiceStato.equals(ITALIA))
        return FormUtils.isCodicePartitaIVA(value);
      return true;
    }
  }

  @Override
  protected String getTypeOfError()
  {
    if(mustBeUnique != null)
    {
      logger.info("Checking unique constraint.");
      try
      {
        logger.info("validator type:" + validatorType);
        if(validatorType.equalsIgnoreCase("fornitore"))
          return validateFornitore();
        if(validatorType.equalsIgnoreCase("cessionario"))
          return validateCessionario();
        if(validatorType.equalsIgnoreCase("service"))
          return validateService();
        if(validatorType.equalsIgnoreCase("enteprevidenziale"))
          return validateEntePrevidenziale();        
        return "Invalid validator type!";
      }
      catch(Exception e)
      {
        logger.error("Unable to verify partita IVA unique constraint." + e);
        return "Unable to verify partita IVA unique constraint.";
      }
    }
    return null;
  }

  private String validateEntePrevidenziale()
  {
      return null;
  }

  private String validateFornitore()
  {
    return null;
  }

  private String validateCessionario()
  {
    return null;
  }

  private String validateService()
  {
    return null;
  }
}
