/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package it.laitspa.cpf.faces.utils.validator;

import java.io.Serializable;
import java.text.MessageFormat;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

import org.apache.log4j.Logger;

/**
 * 
 * @author Andrea
 */
public abstract class CustomValidator
  implements Validator, Serializable
{

  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  protected Logger logger;
  protected Object objectValue;

  public CustomValidator()
  {
    logger = Logger.getLogger(this.getClass());
  }

  protected String errorMessage;

  protected String getErrorMessage()
  {
    return errorMessage;
  }

  protected void setErrorMessage(String errorMessage)
  {
    this.errorMessage = errorMessage;
  }

  protected abstract boolean isValidValue(String value);

  protected abstract String getTypeOfError();

  public void validate(FacesContext context, UIComponent component, Object inputValue)
    throws ValidatorException
  {

    objectValue = inputValue;
    String value = null;
    try
    {
      if(inputValue instanceof Integer)
        value = inputValue != null ? ((Integer)inputValue).toString() : null;
      else
        value = (String)inputValue;
    }
    catch(ClassCastException e)
    {
      logger.error("ClassCastException: can't convert " + inputValue.getClass() + "in String.");
      throw new ValidatorException(new FacesMessage("Validation Error: Value "
          + "cannot be converted to String.", null));
    }

    if(!isValidValue(value))
    {
      String messageText = errorMessage;
      if(messageText == null)
      {
        messageText = "Validation Error: " + component.getId()+ " is not formatted " + "properly.";
      }
      else
      {
        String labelValue = (String)component.getAttributes().get("label_custom");
        if(labelValue != null && labelValue.trim().length() > 0)
          messageText = MessageFormat.format("{0} - {1}", new Object[]{labelValue, messageText});
      }
      throw new ValidatorException(new FacesMessage(messageText, null));
    }
    // Specialized Error
    //
    String typeOfError = getTypeOfError();
    if(typeOfError != null)
    {
      throw new ValidatorException(new FacesMessage(typeOfError, null));
    }
  }

}
