/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.faces.utils.converter;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

import org.richfaces.component.UICalendar;

/**
 * @author andrea
 * 
 */
public class XmlCalendarConverter
  implements Converter
{

  public Object getAsObject(FacesContext context, UIComponent component, String value)
  {
    XMLGregorianCalendar xgc = null;
    GregorianCalendar cal = null;
    if(value != null && value.length() > 0)
    {
      Locale locale = (Locale)((UICalendar)component).getLocale();
      String pattern = ((UICalendar)component).getDatePattern();
      DateFormat df = new SimpleDateFormat(pattern, locale);

      try
      {
        Date date = df.parse(value);
        cal = new GregorianCalendar();
        cal.setTime(date);
        xgc = DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
      }
      catch(Exception e)
      {
        throw new ConverterException(e);
      }
    }
    return xgc;
  }

  public String getAsString(FacesContext context, UIComponent component, Object value)
  {
    String result = null;

    if(value != null)
    {
      if(value instanceof String)
      {
        result = (String)value;
      }
      else
      {
        DateFormat df;
        if(component instanceof UICalendar)
        {
          Locale locale = (Locale)((UICalendar)component).getLocale();
          String pattern = ((UICalendar)component).getDatePattern();
          df = new SimpleDateFormat(pattern, locale);
        }
        else
        {
          Locale locale = context.getViewRoot().getLocale();
          df = DateFormat.getDateInstance(DateFormat.DEFAULT, locale);
        }

        Date date = ((XMLGregorianCalendar) value).toGregorianCalendar().getTime();
        result = df.format(date);
      }
    }
    return result;
  }

}
