/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package it.laitspa.cpf.faces.utils;

import javax.servlet.ServletContext;

import org.quartz.JobExecutionContext;
import org.quartz.Scheduler;
import org.quartz.SchedulerContext;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

/**
 * 
 * @author Andrea
 */
public class FacesJobUtils extends FacesUtils
{
	public static Object findBean(String name, JobExecutionContext context)
	  {
	    Object res = null;
	    try
	    {
	      Scheduler scheduler = context.getScheduler();
	      SchedulerContext sContext = scheduler.getContext();
	      ApplicationContext appContext = (ApplicationContext)sContext.get("applicationContext");
	      res = appContext.getBean(name);
	      if(res == null)
	      {
	        String msg = "Unable to retrieve spring bean: " + name;
	        logger.error(msg);
	      }
	    }
	    catch(Exception e)
	    {
	      logger.error(e);
	    }
	    return res;
	  }
	
	public static Object getInitParameter(String name, JobExecutionContext jec)
	  {
	    Object res = null;
	    try
	    {
	      Scheduler scheduler = jec.getScheduler();
	      SchedulerContext sContext = scheduler.getContext();
	      ApplicationContext appContext = (ApplicationContext)sContext.get("applicationContext");
	      WebApplicationContext wc = (WebApplicationContext)appContext;
	      ServletContext sc = wc.getServletContext();
	      res = sc.getInitParameter(name);
	    }
	    catch(Exception e)
	    {
	      logger.error(e);
	    }
	    return res;
	  }
	
}
