/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.faces.sogei;

import it.laitspa.cpf.faces.BeanModel;
import it.laitspa.cpf.faces.utils.DataPage;
import it.laitspa.cpf.faces.utils.ExtendableDataModel;
import it.laitspa.cpf.faces.utils.FacesUtils;
import it.laitspa.cpf.model.QueryResult;
import it.laitspa.cpf.model.sogei.soggetto.CodiceIpaSogei;
import it.laitspa.cpf.model.sogei.soggetto.SoggettoSogei;
import it.laitspa.cpf.spring.lut.LUTFacade;
import it.laitspa.cpf.spring.sogei.SogeiFacade;
import it.laitspa.cpf.util.misc.FormUtils;

import java.util.List;

import javax.faces.event.ActionEvent;

/**
 * @author andrea
 *
 */
public class SBean
  extends BeanModel
{
  
  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  
  private String denominazione;
  private String cognome;
  private String nome;
  private String identificativoFiscale;
  private String codiceFiscale;
  private String codiceIpa;
  private ExtendableDataModel<SoggettoSogei> listaSoggetti;
  
  
  private Integer codiceSoggetto;
  private List<CodiceIpaSogei> listaCodici;
  private String               nuovoCodice;
  
  public class SgModel extends ExtendableDataModel<SoggettoSogei>
  {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    public SgModel(int pageSize)
    {
      super(pageSize);
    }

    @SuppressWarnings("unchecked")
    @Override
    public DataPage<SoggettoSogei> fetchPage(int startRow, int pageSize)
    {
      
      String denominazione = FormUtils.makeQueryParameter(getDenominazione());
      String cognome = FormUtils.makeQueryParameter(getCognome());
      String nome = FormUtils.makeQueryParameter(getNome());
      String identificativoFiscale = FormUtils.makeQueryParameter(getIdentificativoFiscale());
      String codiceFiscale = FormUtils.makeQueryParameter(getCodiceFiscale());
      String codiceIpa = FormUtils.makeQueryParameter(getCodiceIpa());
      
      // ISogei 
      //
      SogeiFacade sdao = (SogeiFacade) FacesUtils.findBean("SogeiFacade");
      QueryResult qr = sdao.listSoggettiByQuery(denominazione, cognome, nome, identificativoFiscale,
          codiceFiscale, codiceIpa, startRow, pageSize);
      
      return new DataPage<SoggettoSogei>(qr.getCount(), startRow, qr.getItems());
    }
    
  }

  public ExtendableDataModel<SoggettoSogei> getListaSoggetti()
  {
    if (listaSoggetti == null)
      listaSoggetti = new SgModel(20); 
    return listaSoggetti;
  }

  public void setListaSoggetti(ExtendableDataModel<SoggettoSogei> listaSoggetti)
  {
    this.listaSoggetti = listaSoggetti;
  }

  public String getDenominazione()
  {
    return denominazione;
  }

  public void setDenominazione(String denominazione)
  {
    this.denominazione = denominazione;
  }

  public String getCognome()
  {
    return cognome;
  }

  public void setCognome(String cognome)
  {
    this.cognome = cognome;
  }

  public String getNome()
  {
    return nome;
  }

  public void setNome(String nome)
  {
    this.nome = nome;
  }

  public String getIdentificativoFiscale()
  {
    return identificativoFiscale;
  }

  public void setIdentificativoFiscale(String identificativoFiscale)
  {
    this.identificativoFiscale = identificativoFiscale;
  }

  public String getCodiceFiscale()
  {
    return codiceFiscale;
  }

  public void setCodiceFiscale(String codiceFiscale)
  {
    this.codiceFiscale = codiceFiscale;
  }

  public String getCodiceIpa()
  {
    return codiceIpa;
  }

  public void setCodiceIpa(String codiceIpa)
  {
    this.codiceIpa = codiceIpa;
  }
  
  public Integer getCodiceSoggetto()
  {
    return codiceSoggetto;
  }

  public void setCodiceSoggetto(Integer codiceSoggetto)
  {
    this.codiceSoggetto = codiceSoggetto;
  }

  public List<CodiceIpaSogei> getListaCodici()
  {
    return listaCodici;
  }

  public void setListaCodici(List<CodiceIpaSogei> listaCodici)
  {
    this.listaCodici = listaCodici;
  }

  public String getNuovoCodice()
  {
    return nuovoCodice;
  }

  public void setNuovoCodice(String nuovoCodice)
  {
    this.nuovoCodice = nuovoCodice;
  }

  public String doSearch()
  {
    listaSoggetti = null;
    return "success";
  }
  
  @SuppressWarnings("unchecked")
  public void doPrepareForCodici(ActionEvent e)
  {
    listaCodici = null;
    codiceSoggetto = null;
    nuovoCodice = null;
    
    String id = (String) FacesUtils.getRequestParameter("codice");
    if (id == null)
      return;
    
    codiceSoggetto = FormUtils.makeIntegerQueryParameter(id);
    
    // ILut
    //
    LUTFacade ldao = (LUTFacade) FacesUtils.findBean("LUTFacade");
    listaCodici = ldao.retrieve("CodiceIpaSogei", "codiceIpa", "soggetto.codice", codiceSoggetto);
  }
  
  @SuppressWarnings("unchecked")
  public void doEliminaCodice(ActionEvent e)
  {
    String id = (String) FacesUtils.getRequestParameter("codice");
    if (id == null)
      return;
    
    Integer codice =  FormUtils.makeIntegerQueryParameter(id);
    
    // ISogei
    //
    SogeiFacade sdao = (SogeiFacade) FacesUtils.findBean("SogeiFacade");
    if (sdao.deleteCodiceIpa(codice))
    {
      FacesUtils.addContextMessage(getClass(), "message_deletecodiceipadone_title", "message_deletecodiceipadone_text");
      // ILut
      //
      LUTFacade ldao = (LUTFacade) FacesUtils.findBean("LUTFacade");
      listaCodici = ldao.retrieve("CodiceIpaSogei", "codiceIpa", "soggetto.codice", codiceSoggetto);
    }
    else
      FacesUtils.addContextErrorMessage(getClass(), "error_deletecodiceipa");
  }  
  
  @SuppressWarnings("unchecked")
  public void doAddCodice(ActionEvent e)
  {
    
    if (codiceSoggetto == null)
      return;
    
    // Check if already existing.
    //
    String codiceIpa = FormUtils.makeQueryParameter(getNuovoCodice());
    if (codiceIpa != null)
      codiceIpa = codiceIpa.toUpperCase();
    
    // ISogei
    //
    SogeiFacade sdao = (SogeiFacade) FacesUtils.findBean("SogeiFacade");
    if (sdao.isCodiceIpaAlreadyPresent(codiceIpa))
      FacesUtils.addContextErrorMessage(getClass(), "error_addcodiceipa");
    else
    {
      sdao.saveCodiceIpaForSoggetto(codiceSoggetto, codiceIpa);
      FacesUtils.addContextMessage(getClass(), "message_addcodiceipadone_title", "message_addcodiceipadone_text");
      
      // ILut
      //
      LUTFacade ldao = (LUTFacade) FacesUtils.findBean("LUTFacade");
      listaCodici = ldao.retrieve("CodiceIpaSogei", "codiceIpa", "soggetto.codice", codiceSoggetto);
    }
  }  

}
