/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")- non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.faces.sogei;

import it.laitspa.cpf.faces.BeanModel;
import it.laitspa.cpf.faces.streaming.StreamingBean;
import it.laitspa.cpf.faces.utils.DataPage;
import it.laitspa.cpf.faces.utils.ExtendableDataModel;
import it.laitspa.cpf.faces.utils.FacesUtils;
import it.laitspa.cpf.faces.utils.versionefattura.VersioneFatturaPaHelper;
import it.laitspa.cpf.model.QueryResult;
import it.laitspa.cpf.model.sogei.fattura.FatturaSogei;
import it.laitspa.cpf.model.sogei.notifica.NotificaSogei;
import it.laitspa.cpf.model.sogei.soggetto.SoggettoSogei;
import it.laitspa.cpf.model.sogei.statofattura.StatoFatturaSogei;
import it.laitspa.cpf.spring.lut.LUTFacade;
import it.laitspa.cpf.spring.sogei.SogeiFacade;
import it.laitspa.cpf.util.log.LogUtils;
import it.laitspa.cpf.util.misc.FormUtils;

import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.List;

/**
 * @author andrea
 * 
 */
public class LBean
  extends BeanModel
{

  public class SMod
    extends ExtendableDataModel<FatturaSogei>
  {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    public SMod(int p)
    {
      super(p);
    }

    @SuppressWarnings("unchecked")
    @Override
    public DataPage<FatturaSogei> fetchPage(int w, int p)
    {
      // Retrieve Parameter.
      //
      String partitaIvaCedente = FormUtils.makeQueryParameter(getPartitaIvaCedente());
      String partitaIvaCommittente = FormUtils.makeQueryParameter(getPartitaIvaCommittente());
      String codiceIpa = FormUtils.makeQueryParameter(getCodiceIpa());
      String numeroFattura = FormUtils.makeQueryParameter(getNumeroFattura());
      
      Integer codiceStato = FormUtils.makeIntegerQueryParameterFromSelection(getCodiceStato());
      
      
      SogeiFacade sf = (SogeiFacade) FacesUtils.findBean("SogeiFacade");
      QueryResult qr = sf.listQueryResult(SoggettoSogei.SOGGETTO_UNICO, dataCaricamentoDa, 
          dataCaricamentoA, partitaIvaCedente, 
          partitaIvaCommittente, codiceIpa, codiceStato, 
          numeroFattura, dataFatturaDa, dataFatturaA, w, p);
      return new DataPage<FatturaSogei>(qr.getCount(), w, qr.getItems());
    }

    @Override
    public Object getObjectPk(Object row)
    {
      return super.getObjectPk(row);
    }

  }

  /**
   * 
   */
  private static final long   serialVersionUID = 1L;

  private SMod                model;
  private List<NotificaSogei> notifiche;
  private boolean             showPanel        = false;

  private Date                dataCaricamentoDa;
  private Date                dataCaricamentoA;
  private String              partitaIvaCedente;
  private String              partitaIvaCommittente;
  private String              codiceIpa;
  private String              numeroFattura;
  private Date                dataFatturaDa;
  private Date                dataFatturaA;
  
  private Integer             codiceStato;
  private List<SelectItem>    listStato;
  private SoggettoSogei       soggetto;
  
  

  public Integer getCodiceStato()
  {
    return codiceStato;
  }

  public void setCodiceStato(Integer codiceStato)
  {
    this.codiceStato = codiceStato;
  }

  public List<SelectItem> getListStato()
  {
    if (listStato == null)
    {
      LUTFacade ldao = (LUTFacade) FacesUtils.findBean("LUTFacade");
      @SuppressWarnings("unchecked")
      List<StatoFatturaSogei> stati = ldao.retrieve("StatoFatturaSogei", "label");
      listStato = FacesUtils.toSelectItems(stati, "getCodice", "getLabel"); 
    }
    return listStato;
  }

  public void setListStato(List<SelectItem> listStato)
  {
    this.listStato = listStato;
  }

  public Date getDataCaricamentoDa()
  {
    return dataCaricamentoDa;
  }

  public void setDataCaricamentoDa(Date dataCaricamentoDa)
  {
    this.dataCaricamentoDa = dataCaricamentoDa;
  }

  public Date getDataCaricamentoA()
  {
    return dataCaricamentoA;
  }

  public void setDataCaricamentoA(Date dataCaricamentoA)
  {
    this.dataCaricamentoA = dataCaricamentoA;
  }

  public String getPartitaIvaCedente()
  {
    return partitaIvaCedente;
  }

  public void setPartitaIvaCedente(String partitaIvaCedente)
  {
    this.partitaIvaCedente = partitaIvaCedente;
  }

  public String getPartitaIvaCommittente()
  {
    return partitaIvaCommittente;
  }

  public void setPartitaIvaCommittente(String partitaIvaCommittente)
  {
    this.partitaIvaCommittente = partitaIvaCommittente;
  }

  public String getCodiceIpa()
  {
    return codiceIpa;
  }

  public void setCodiceIpa(String codiceIpa)
  {
    this.codiceIpa = codiceIpa;
  }

  public String getNumeroFattura()
  {
    return numeroFattura;
  }

  public void setNumeroFattura(String numeroFattura)
  {
    this.numeroFattura = numeroFattura;
  }

  public Date getDataFatturaDa()
  {
    return dataFatturaDa;
  }

  public void setDataFatturaDa(Date dataFatturaDa)
  {
    this.dataFatturaDa = dataFatturaDa;
  }

  public Date getDataFatturaA()
  {
    return dataFatturaA;
  }

  public void setDataFatturaA(Date dataFatturaA)
  {
    this.dataFatturaA = dataFatturaA;
  }

  public SMod getModel()
  {
    if (model == null)
      model = new SMod(20);
    return model;
  }

  public void setModel(SMod model)
  {
    this.model = model;
  }

  public List<NotificaSogei> getNotifiche()
  {
    return notifiche;
  }

  public void setNotifiche(List<NotificaSogei> notifiche)
  {
    this.notifiche = notifiche;
  }

  public boolean isShowPanel()
  {
    return showPanel;
  }

  public void setShowPanel(boolean showPanel)
  {
    this.showPanel = showPanel;
  }

  public SoggettoSogei getSoggetto()
  {
    if (soggetto == null)
    {
      LUTFacade sdao = (LUTFacade) FacesUtils.findBean("LUTFacade");
      soggetto = (SoggettoSogei)sdao.getItem("SoggettoSogei", SoggettoSogei.SOGGETTO_UNICO);
    }
    return soggetto;
  }

  public void setSoggetto(SoggettoSogei soggetto)
  {
    this.soggetto = soggetto;
  }

  public String doSearch()
  {
    this.model = null;
    return "success";
  }
  
  
  public void doN(ActionEvent e)
  {
    throw new UnsupportedOperationException("Operazione non implementata.");
  }

  public void doU(ActionEvent e)
  {
    this.showPanel = false;
  }

  public void doX(ActionEvent e)
  {
    Integer codice =
        FormUtils.makeIntegerQueryParameter((String)FacesUtils.getRequestParameter("id"));

    SogeiFacade sf = (SogeiFacade) FacesUtils.findBean("SogeiFacade");
    byte[] data = sf.createX(codice);

    StreamingBean s = FacesUtils.getFacesBean(StreamingBean.class);
    s.setContentType("application/xml");
    s.setData(data);
    s.setFileName("export.xml");
    s.setInline(false);

    s.doCallStreamingServlet();
  }
  
  public String doSX()
  {
    Integer codice =
        FormUtils.makeIntegerQueryParameter((String)FacesUtils.getRequestParameter("id"));

    SogeiFacade sf = (SogeiFacade) FacesUtils.findBean("SogeiFacade");
    byte[] data = sf.createX(codice);
    
    // Insert instruction.
    //
    try
    {
      // Input stream from data
      //
      InputStream is = new ByteArrayInputStream(data);
      StreamSource sis = new StreamSource(is); 
      
      //  Create Transformer
      //
      InputStream xsl = VersioneFatturaPaHelper.getFoglioDiStile(data);
      TransformerFactory tf = TransformerFactory.newInstance();
      StreamSource xslt = new StreamSource(xsl);
      
      Transformer transformer = tf.newTransformer(xslt);
      
      ByteArrayOutputStream bos = new ByteArrayOutputStream();
      
      // Result
      //
      StreamResult result = new StreamResult(bos);
      
      // Transform
      //
      transformer.transform(sis, result);
      bos.close();
      xsl.close();
      is.close();
      
      data = bos.toByteArray();
    }
    catch (Exception ex)
    {
      LogUtils.error(getClass(), "Error caught while insert xml instruction.", ex);
    }
    

    StreamingBean s = FacesUtils.getFacesBean(StreamingBean.class);
    s.setBackUrl(FacesUtils.getCurrentView());
    s.setContentType("text/html");
    s.setData(data);
    s.setFileName("export.html");
    s.setInline(true);

    return StreamingBean.FORWARD_MESSAGE;
  }

  public void doY(ActionEvent e)
  {
    throw new UnsupportedOperationException("Operazione non implementata.");
  }

  public void doF(ActionEvent e)
  {
    throw new UnsupportedOperationException("Operazione non implementata.");
  }


}
