/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.faces.sogei;

import javax.faces.event.ActionEvent;

import it.laitspa.cpf.faces.BeanModel;
import it.laitspa.cpf.faces.utils.FacesUtils;
import it.laitspa.cpf.model.sogei.soggetto.SoggettoSogei;
import it.laitspa.cpf.spring.lut.LUTFacade;
import it.laitspa.cpf.spring.sogei.SogeiFacade;
import it.laitspa.cpf.util.misc.FormUtils;

/**
 * @author andrea
 * 
 */
public class DBean
  extends BeanModel
{

  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  private String            nazione;

  private String            codiceIdentificativoFiscale;

  private String            codiceFiscale;

  private String            denominazione;
  private String            nome;
  private String            cognome;
  private String            descrizioneTitolare;
  private String            descrizioneCodiceEori;
  private String            mail;

  
  public DBean()
  {
    LUTFacade ldao = (LUTFacade) FacesUtils.findBean("LUTFacade");
    SoggettoSogei soggetto = (SoggettoSogei) ldao.getItem("SoggettoSogei", SoggettoSogei.SOGGETTO_UNICO);
    if (soggetto != null)
    {
      nazione = soggetto.getNazione();
      codiceIdentificativoFiscale = soggetto.getCodiceIdentificativoFiscale();
      codiceFiscale = soggetto.getCodiceFiscale();
      denominazione = soggetto.getDenominazione();
      nome = soggetto.getNome();
      cognome = soggetto.getCognome();
      descrizioneTitolare = soggetto.getDescrizioneTitolare();
      descrizioneCodiceEori = soggetto.getDescrizioneCodiceEori();
      mail = soggetto.getMail();
    }
  }
  
  
  public String getNazione()
  {
    return nazione;
  }

  public void setNazione(String nazione)
  {
    this.nazione = nazione;
  }

  public String getCodiceIdentificativoFiscale()
  {
    return codiceIdentificativoFiscale;
  }

  public void setCodiceIdentificativoFiscale(String codiceIdentificativoFiscale)
  {
    this.codiceIdentificativoFiscale = codiceIdentificativoFiscale;
  }

  public String getCodiceFiscale()
  {
    return codiceFiscale;
  }

  public void setCodiceFiscale(String codiceFiscale)
  {
    this.codiceFiscale = codiceFiscale;
  }

  public String getDenominazione()
  {
    return denominazione;
  }

  public void setDenominazione(String denominazione)
  {
    this.denominazione = denominazione;
  }

  public String getNome()
  {
    return nome;
  }

  public void setNome(String nome)
  {
    this.nome = nome;
  }

  public String getCognome()
  {
    return cognome;
  }

  public void setCognome(String cognome)
  {
    this.cognome = cognome;
  }

  public String getDescrizioneTitolare()
  {
    return descrizioneTitolare;
  }

  public void setDescrizioneTitolare(String descrizioneTitolare)
  {
    this.descrizioneTitolare = descrizioneTitolare;
  }

  public String getDescrizioneCodiceEori()
  {
    return descrizioneCodiceEori;
  }

  public void setDescrizioneCodiceEori(String descrizioneCodiceEori)
  {
    this.descrizioneCodiceEori = descrizioneCodiceEori;
  }

  public String getMail()
  {
    return mail;
  }

  public void setMail(String mail)
  {
    this.mail = mail;
  }
  
  public void doSave(ActionEvent e)
  {
    String nazione = FormUtils.makeQueryParameter(this.nazione);
    String codiceIdentificativoFiscale = FormUtils.makeQueryParameter(this.codiceIdentificativoFiscale);
    String codiceFiscale = FormUtils.makeQueryParameter(this.codiceFiscale);
    String denominazione = FormUtils.makeQueryParameter(this.denominazione);
    String nome = FormUtils.makeQueryParameter(this.nome);
    String cognome = FormUtils.makeQueryParameter(this.cognome);
    String descrizioneTitolare = FormUtils.makeQueryParameter(this.descrizioneTitolare);
    String descrizioneCodiceEori = FormUtils.makeQueryParameter(this.descrizioneCodiceEori);
    String mail = FormUtils.makeQueryParameter(this.mail);
    
    if (nazione.equalsIgnoreCase("IT"))
    {
      // Check piva.
      //
      if (!FormUtils.isCodicePartitaIVA(codiceIdentificativoFiscale)
          && !FormUtils.isCodiceFiscale(codiceIdentificativoFiscale))
      {
        FacesUtils.addContextErrorMessage(getClass(), "error_identificativo_mustbevalid");
        return;
      }
    }
    
    SogeiFacade sdao = (SogeiFacade)FacesUtils.findBean("SogeiFacade");
    if (sdao.saveAnagraficaSoggetto(SoggettoSogei.SOGGETTO_UNICO, nazione, codiceIdentificativoFiscale, 
        codiceFiscale, denominazione, nome, cognome, descrizioneTitolare, descrizioneCodiceEori, mail))
      FacesUtils.addContextMessage(getClass(), "message_saveanagraficadone_title", "message_saveanagraficadone_text");
    else
      FacesUtils.addContextErrorMessage(getClass(), "message_saveanagraficaerror_text");
    
  }

}
