/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * @author andrea
 */

package it.laitspa.cpf.faces;

import it.laitspa.cpf.util.misc.FormUtils;

import java.io.Serializable;
import java.lang.reflect.Method;

public abstract class BeanModel
  implements Serializable
{

  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  protected Integer         entityId;
  protected boolean         built = false;

  /**
   * TODO implement
   */
  public void clean()
  {

    try
    {
      Method[] ms = this.getClass().getDeclaredMethods();
      for(Method m : ms)
      {
        if(m.getName().startsWith("set"))
          m.invoke(this, (Object[])null);
      }
    }
    catch(Exception e)
    {
      // Nothing.
      //
    }

  }
  

  public Integer getEntityId()
  {
    return FormUtils.makeIntegerQueryParameterFromSelection(entityId);
  }



  public void setEntityId(Integer entityId)
  {
    this.entityId = entityId;
  }



  public void build()
  {
    // Simply nothing to do.
    //
  }

}
