/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KEKIdentifier;
import org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.bouncycastle.asn1.cms.KeyAgreeRecipientIdentifier;
import org.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.OriginatorIdentifierOrKey;
import org.bouncycastle.asn1.cms.OriginatorPublicKey;
import org.bouncycastle.asn1.cms.PasswordRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientEncryptedKey;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSPBEKey;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.jce.PrincipalUtil;

public class CMSEnvelopedGenerator {
    public static final String DES_EDE3_CBC = PKCSObjectIdentifiers.des_EDE3_CBC.getId();
    public static final String RC2_CBC = PKCSObjectIdentifiers.RC2_CBC.getId();
    public static final String IDEA_CBC = "1.3.6.1.4.1.188.7.1.1.2";
    public static final String CAST5_CBC = "1.2.840.113533.7.66.10";
    public static final String AES128_CBC = NISTObjectIdentifiers.id_aes128_CBC.getId();
    public static final String AES192_CBC = NISTObjectIdentifiers.id_aes192_CBC.getId();
    public static final String AES256_CBC = NISTObjectIdentifiers.id_aes256_CBC.getId();
    public static final String CAMELLIA128_CBC = NTTObjectIdentifiers.id_camellia128_cbc.getId();
    public static final String CAMELLIA192_CBC = NTTObjectIdentifiers.id_camellia192_cbc.getId();
    public static final String CAMELLIA256_CBC = NTTObjectIdentifiers.id_camellia256_cbc.getId();
    public static final String SEED_CBC = KISAObjectIdentifiers.id_seedCBC.getId();
    public static final String DES_EDE3_WRAP = PKCSObjectIdentifiers.id_alg_CMS3DESwrap.getId();
    public static final String AES128_WRAP = NISTObjectIdentifiers.id_aes128_wrap.getId();
    public static final String AES192_WRAP = NISTObjectIdentifiers.id_aes192_wrap.getId();
    public static final String AES256_WRAP = NISTObjectIdentifiers.id_aes256_wrap.getId();
    public static final String CAMELLIA128_WRAP = NTTObjectIdentifiers.id_camellia128_wrap.getId();
    public static final String CAMELLIA192_WRAP = NTTObjectIdentifiers.id_camellia192_wrap.getId();
    public static final String CAMELLIA256_WRAP = NTTObjectIdentifiers.id_camellia256_wrap.getId();
    public static final String SEED_WRAP = KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap.getId();
    public static final String ECDH_SHA1KDF = X9ObjectIdentifiers.dhSinglePass_stdDH_sha1kdf_scheme.getId();
    private static final CMSEnvelopedHelper HELPER = CMSEnvelopedHelper.INSTANCE;
    final List recipientInfs = new ArrayList();
    final SecureRandom rand;

    public CMSEnvelopedGenerator() {
        this(new SecureRandom());
    }

    public CMSEnvelopedGenerator(SecureRandom secureRandom) {
        this.rand = secureRandom;
    }

    public void addKeyTransRecipient(X509Certificate x509Certificate) throws IllegalArgumentException {
        this.recipientInfs.add(new RecipientInf(x509Certificate));
    }

    public void addKeyTransRecipient(PublicKey publicKey, byte[] byArray) throws IllegalArgumentException {
        this.recipientInfs.add(new RecipientInf(publicKey, (ASN1OctetString)new DEROctetString(byArray)));
    }

    public void addKEKRecipient(SecretKey secretKey, byte[] byArray) {
        this.recipientInfs.add(new RecipientInf(secretKey, new KEKIdentifier(byArray, null, null)));
    }

    public void addPasswordRecipient(CMSPBEKey cMSPBEKey, String string) {
        PBKDF2Params pBKDF2Params = new PBKDF2Params(cMSPBEKey.getSalt(), cMSPBEKey.getIterationCount());
        this.recipientInfs.add(new RecipientInf((SecretKey)new SecretKeySpec(cMSPBEKey.getEncoded(string), string), new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBKDF2, (DEREncodable)pBKDF2Params)));
    }

    public void addKeyAgreementRecipient(String string, PrivateKey privateKey, PublicKey publicKey, X509Certificate x509Certificate, String string2, String string3) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException {
        this.addKeyAgreementRecipient(string, privateKey, publicKey, x509Certificate, string2, CMSUtils.getProvider(string3));
    }

    public void addKeyAgreementRecipient(String string, PrivateKey privateKey, PublicKey publicKey, X509Certificate x509Certificate, String string2, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        KeyAgreement keyAgreement = KeyAgreement.getInstance(string, provider);
        keyAgreement.init((Key)privateKey, this.rand);
        keyAgreement.doPhase(x509Certificate.getPublicKey(), true);
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)ASN1Object.fromByteArray((byte[])publicKey.getEncoded()));
            OriginatorIdentifierOrKey originatorIdentifierOrKey = new OriginatorIdentifierOrKey(new OriginatorPublicKey(new AlgorithmIdentifier(subjectPublicKeyInfo.getAlgorithmId().getObjectId(), (DEREncodable)new DERNull()), subjectPublicKeyInfo.getPublicKeyData().getBytes()));
            this.recipientInfs.add(new RecipientInf(keyAgreement.generateSecret(string2), string, string2, originatorIdentifierOrKey, x509Certificate));
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("cannot extract originator public key: " + iOException);
        }
    }

    protected AlgorithmIdentifier getAlgorithmIdentifier(String string, AlgorithmParameters algorithmParameters) throws IOException {
        DERNull dERNull;
        ASN1InputStream aSN1InputStream;
        if (algorithmParameters != null) {
            aSN1InputStream = new ASN1InputStream(algorithmParameters.getEncoded("ASN.1"));
            dERNull = aSN1InputStream.readObject();
        } else {
            dERNull = new DERNull();
        }
        aSN1InputStream = new AlgorithmIdentifier(new DERObjectIdentifier(string), (DEREncodable)dERNull);
        return aSN1InputStream;
    }

    protected AlgorithmParameters generateParameters(String string, SecretKey secretKey, Provider provider) throws CMSException {
        try {
            AlgorithmParameterGenerator algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance(string, provider);
            if (string.equals(RC2_CBC)) {
                byte[] byArray = new byte[8];
                this.rand.setSeed(System.currentTimeMillis());
                this.rand.nextBytes(byArray);
                try {
                    algorithmParameterGenerator.init(new RC2ParameterSpec(secretKey.getEncoded().length * 8, byArray), this.rand);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new CMSException("parameters generation error: " + invalidAlgorithmParameterException, invalidAlgorithmParameterException);
                }
            }
            return algorithmParameterGenerator.generateParameters();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    protected class RecipientInf {
        X509Certificate cert;
        AlgorithmIdentifier keyEncAlg;
        PublicKey pubKey;
        ASN1OctetString subKeyId;
        SecretKey secKey;
        KEKIdentifier secKeyId;
        OriginatorIdentifierOrKey originator;
        ASN1OctetString ukm;
        AlgorithmIdentifier derivationAlg;

        RecipientInf(X509Certificate x509Certificate) {
            this.cert = x509Certificate;
            this.pubKey = x509Certificate.getPublicKey();
            try {
                TBSCertificateStructure tBSCertificateStructure = TBSCertificateStructure.getInstance((Object)ASN1Object.fromByteArray((byte[])x509Certificate.getTBSCertificate()));
                SubjectPublicKeyInfo subjectPublicKeyInfo = tBSCertificateStructure.getSubjectPublicKeyInfo();
                this.keyEncAlg = subjectPublicKeyInfo.getAlgorithmId();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("can't extract key algorithm from this cert");
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IllegalArgumentException("can't extract tbs structure from this cert");
            }
        }

        RecipientInf(PublicKey publicKey, ASN1OctetString aSN1OctetString) {
            this.pubKey = publicKey;
            this.subKeyId = aSN1OctetString;
            try {
                SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)ASN1Object.fromByteArray((byte[])publicKey.getEncoded()));
                this.keyEncAlg = subjectPublicKeyInfo.getAlgorithmId();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("can't extract key algorithm from this key");
            }
        }

        RecipientInf(SecretKey secretKey, KEKIdentifier kEKIdentifier) {
            this.secKey = secretKey;
            this.secKeyId = kEKIdentifier;
            if (secretKey.getAlgorithm().startsWith("DES")) {
                this.keyEncAlg = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.9.16.3.6"), (DEREncodable)new DERNull());
            } else if (secretKey.getAlgorithm().startsWith("RC2")) {
                this.keyEncAlg = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.9.16.3.7"), (DEREncodable)new DERInteger(58));
            } else if (secretKey.getAlgorithm().startsWith("AES")) {
                DERObjectIdentifier dERObjectIdentifier;
                int n = secretKey.getEncoded().length * 8;
                if (n == 128) {
                    dERObjectIdentifier = NISTObjectIdentifiers.id_aes128_wrap;
                } else if (n == 192) {
                    dERObjectIdentifier = NISTObjectIdentifiers.id_aes192_wrap;
                } else if (n == 256) {
                    dERObjectIdentifier = NISTObjectIdentifiers.id_aes256_wrap;
                } else {
                    throw new IllegalArgumentException("illegal keysize in AES");
                }
                this.keyEncAlg = new AlgorithmIdentifier(dERObjectIdentifier);
            } else if (secretKey.getAlgorithm().startsWith("SEED")) {
                this.keyEncAlg = new AlgorithmIdentifier(KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap);
            } else if (secretKey.getAlgorithm().startsWith("Camellia")) {
                DERObjectIdentifier dERObjectIdentifier;
                int n = secretKey.getEncoded().length * 8;
                if (n == 128) {
                    dERObjectIdentifier = NTTObjectIdentifiers.id_camellia128_wrap;
                } else if (n == 192) {
                    dERObjectIdentifier = NTTObjectIdentifiers.id_camellia192_wrap;
                } else if (n == 256) {
                    dERObjectIdentifier = NTTObjectIdentifiers.id_camellia256_wrap;
                } else {
                    throw new IllegalArgumentException("illegal keysize in Camellia");
                }
                this.keyEncAlg = new AlgorithmIdentifier(dERObjectIdentifier);
            } else {
                throw new IllegalArgumentException("unknown algorithm");
            }
        }

        public RecipientInf(SecretKey secretKey, String string, String string2, OriginatorIdentifierOrKey originatorIdentifierOrKey, X509Certificate x509Certificate) {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            aSN1EncodableVector.add((DEREncodable)new DERObjectIdentifier(string2));
            aSN1EncodableVector.add((DEREncodable)DERNull.INSTANCE);
            this.secKey = secretKey;
            this.keyEncAlg = new AlgorithmIdentifier(new DERObjectIdentifier(string), (DEREncodable)new DERSequence((DEREncodableVector)aSN1EncodableVector));
            this.originator = originatorIdentifierOrKey;
            this.cert = x509Certificate;
        }

        public RecipientInf(SecretKey secretKey, AlgorithmIdentifier algorithmIdentifier) {
            this.secKey = secretKey;
            this.derivationAlg = algorithmIdentifier;
        }

        RecipientInfo toRecipientInfo(SecretKey secretKey, SecureRandom secureRandom, Provider provider) throws IOException, GeneralSecurityException {
            if (this.pubKey != null) {
                DEROctetString dEROctetString;
                Cipher cipher = HELPER.createAsymmetricCipher(this.keyEncAlg.getObjectId().getId(), provider);
                try {
                    cipher.init(3, (Key)this.pubKey, secureRandom);
                    dEROctetString = new DEROctetString(cipher.wrap(secretKey));
                }
                catch (GeneralSecurityException generalSecurityException) {
                    cipher.init(1, (Key)this.pubKey, secureRandom);
                    dEROctetString = new DEROctetString(cipher.doFinal(secretKey.getEncoded()));
                }
                catch (IllegalStateException illegalStateException) {
                    cipher.init(1, (Key)this.pubKey, secureRandom);
                    dEROctetString = new DEROctetString(cipher.doFinal(secretKey.getEncoded()));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    cipher.init(1, (Key)secretKey, secureRandom);
                    dEROctetString = new DEROctetString(cipher.doFinal(secretKey.getEncoded()));
                }
                if (this.cert != null) {
                    ASN1InputStream aSN1InputStream = new ASN1InputStream(this.cert.getTBSCertificate());
                    TBSCertificateStructure tBSCertificateStructure = TBSCertificateStructure.getInstance((Object)aSN1InputStream.readObject());
                    IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(tBSCertificateStructure.getIssuer(), tBSCertificateStructure.getSerialNumber().getValue());
                    return new RecipientInfo(new KeyTransRecipientInfo(new RecipientIdentifier(issuerAndSerialNumber), this.keyEncAlg, (ASN1OctetString)dEROctetString));
                }
                return new RecipientInfo(new KeyTransRecipientInfo(new RecipientIdentifier(this.subKeyId), this.keyEncAlg, (ASN1OctetString)dEROctetString));
            }
            if (this.originator != null) {
                Cipher cipher = HELPER.createAsymmetricCipher(DERObjectIdentifier.getInstance((Object)ASN1Sequence.getInstance((Object)this.keyEncAlg.getParameters()).getObjectAt(0)).getId(), provider);
                cipher.init(3, (Key)this.secKey, secureRandom);
                DEROctetString dEROctetString = new DEROctetString(cipher.wrap(secretKey));
                RecipientEncryptedKey recipientEncryptedKey = new RecipientEncryptedKey(new KeyAgreeRecipientIdentifier(new IssuerAndSerialNumber((X509Name)PrincipalUtil.getIssuerX509Principal((X509Certificate)this.cert), this.cert.getSerialNumber())), (ASN1OctetString)dEROctetString);
                return new RecipientInfo(new KeyAgreeRecipientInfo(this.originator, this.ukm, this.keyEncAlg, (ASN1Sequence)new DERSequence((DEREncodable)recipientEncryptedKey)));
            }
            if (this.derivationAlg != null) {
                Cipher cipher = HELPER.createAsymmetricCipher(HELPER.getRFC3211WrapperName(this.secKey.getAlgorithm()), provider);
                cipher.init(3, (Key)this.secKey, secureRandom);
                DEROctetString dEROctetString = new DEROctetString(cipher.wrap(secretKey));
                ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                aSN1EncodableVector.add((DEREncodable)new DERObjectIdentifier(this.secKey.getAlgorithm()));
                aSN1EncodableVector.add((DEREncodable)new DEROctetString(cipher.getIV()));
                this.keyEncAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_PWRI_KEK, (DEREncodable)new DERSequence((DEREncodableVector)aSN1EncodableVector));
                return new RecipientInfo(new PasswordRecipientInfo(this.derivationAlg, this.keyEncAlg, (ASN1OctetString)dEROctetString));
            }
            Cipher cipher = HELPER.createAsymmetricCipher(this.keyEncAlg.getObjectId().getId(), provider);
            cipher.init(3, (Key)this.secKey, secureRandom);
            DEROctetString dEROctetString = new DEROctetString(cipher.wrap(secretKey));
            return new RecipientInfo(new KEKRecipientInfo(this.secKeyId, this.keyEncAlg, (ASN1OctetString)dEROctetString));
        }
    }
}

