/*
 * Copyright 2014 - LAit SpA
 *				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
 *
 * Concesso in licenza a norma dell'EUPL, versione 1.1 o
 * successive dell'EUPL (la "Licenza")– non appena saranno
 * approvate dalla Commissione europea;
 * Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
 * È possibile ottenere una copia della Licenza al seguente indirizzo:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Salvo diversamente indicato dalla legge applicabile o
 * concordato per iscritto, il software distribuito secondo
 * i termini della Licenza è distribuito "TAL QUALE",
 * SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
 * esplicite o implicite.
 * Si veda la Licenza per la lingua specifica che disciplina
 * le autorizzazioni e le limitazioni secondo i termini della
 * Licenza.
 */
/**
 * 
 */
package it.laitspa.cpf.util.security;

import it.laitspa.cpf.util.misc.Base64Utils;

import java.io.ByteArrayOutputStream;

import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;

/**
 * @author andrea
 * 
 */
public class SignatureVerifier
{

  private static transient Logger logger       = Logger.getLogger(SignatureVerifier.class);

  private Boolean                 isP7M;
  private Boolean                 isValid;
  private Boolean                 isExpired;
  private Boolean                 isVerified;
  private String                  error;

  private byte[]                  encryptedData;
  private byte[]                  content;

  private boolean                 hasOwnerCer;

  public SignatureVerifier(byte[] data)
  {
    isP7M = null;
    isExpired = null;
    isValid = null;
    isVerified = null;
    this.encryptedData = data;
    content = null;
  }

  public boolean isHasOwnerCer()
  {
    return hasOwnerCer;
  }

  public void setHasOwnerCert(boolean hasOwnerCer)
  {
    this.hasOwnerCer = hasOwnerCer;
  }

  public byte[] getContent()
  {
    return content;
  }

  public byte[] getContentByEncrypted()
  {
    try
    {
      logger.info("getContentCalled");
      
      if (Base64Utils.isBase64(encryptedData))
        encryptedData = Base64.decode(encryptedData);
      
      org.bouncycastle.cms.CMSSignedData cms = new org.bouncycastle.cms.CMSSignedData(encryptedData);
      if(cms.getSignedContent() == null)
        return null;

      logger.info("Signed data found.");
      ByteArrayOutputStream out = new ByteArrayOutputStream();
      cms.getSignedContent().write(out);
      return out.toByteArray();

    }
    catch(Exception e)
    {
      e.printStackTrace();
      return null;
    }
  }

  public Boolean getIsP7M()
  {
    return isP7M;
  }

  public Boolean getIsValid()
  {
    return isValid;
  }

  public Boolean getIsExpired()
  {
    return isExpired;
  }

  public Boolean getIsVerified()
  {
    return isVerified;
  }

  public String getError()
  {
    return error;
  }

  public byte[] getEncryptedData()
  {
    return encryptedData;
  }
  
}
