/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
package it.laitspa.cpf.util.security;
import java.security.cert.PKIXCertPathBuilderResult;

/**
 * 
 */

/**
 * @author andrea
 *
 */
public class CertificateVerificationResult {
  private boolean valid;
  private PKIXCertPathBuilderResult result;
  private Throwable exception;

  /**
   * Constructs a certificate verification result for valid
   * certificate by given certification path.
   */
  public CertificateVerificationResult(
      PKIXCertPathBuilderResult result) {
    this.valid = true;
    this.result = result;
  }

  /**
   * Constructs a certificate verification result for invalid
   * certificate by given exception that keeps the problem
   * occurred during the verification process.
   */
  public CertificateVerificationResult(Throwable exception) {
    this.valid = false;
    this.exception = exception;
  }

  public boolean isValid() {
    return valid;
  }

  public PKIXCertPathBuilderResult getResult() {
    return result;
  }

  public Throwable getException() {
    return exception;
  }
}
