/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.util.misc;

import it.laitspa.cpf.util.log.LogUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

/**
 * @author andrea
 *
 */
public class JndiServiceLocator
{

  private static JndiServiceLocator instance;
  
  private ConcurrentHashMap<String, Object> looks;
  private List<String> notAvailables;
  
  /**
   * 
   */
  private JndiServiceLocator()
  {
    looks = new ConcurrentHashMap<String, Object>();
    notAvailables = Collections.synchronizedList(new ArrayList<String>());
  }
  
  public static JndiServiceLocator getInstance()
  {
    if (instance == null)
    {
      instance = new JndiServiceLocator();
      LogUtils.info(JndiServiceLocator.class, "New instance of ServiceLocator successfully builded.");
    }
    
    return instance;
  }
  
  public Object lookup(String key) throws NamingException
  {
    Object look = null;
    
    if (looks.containsKey(key))
      look = looks.get(key);
    else if (!notAvailables.contains(key))
    {
      LogUtils.info(getClass(), "Reading property {0} from JNDI Context.", new Object[]{key});
      InitialContext ctx_i = new InitialContext();
      Context ctx = (Context) ctx_i.lookup("java:comp/env"); // Tomcat wrap java context!
      try
      {
        look = ctx.lookup(key);
        looks.put(key, look);
        LogUtils.info(getClass(), "Property {0} stored on ServiceLocator.", new Object[]{key});
      }
      catch (NamingException e)
      {
        try
        {
          look = ctx_i.lookup(key);
          looks.put(key, look);
          LogUtils.info(getClass(), "Property {0} stored on ServiceLocator.", new Object[]{key});
        }
        catch (NamingException ex)
        {
          notAvailables.add(key);
          LogUtils.info(getClass(), "Property {0} is not available from JNDI.", new Object[]{key});
        }
      }
    }
      
    return look;
  }

}
