/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.util.misc;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Dario
 * 
 */
public class AmountUtils
{
  protected static DecimalFormat amountFormat;
  protected static DecimalFormat priceFormat;
  protected static DecimalFormat percFormat;
  
  static
  {
    DecimalFormatSymbols dfs = new DecimalFormatSymbols();
    dfs.setDecimalSeparator(',');
    
    amountFormat = new DecimalFormat("0.00", dfs);
    priceFormat = new DecimalFormat("0.00###", dfs);
    percFormat = new DecimalFormat("0.###", dfs);
  }

  public static boolean isValidAmount(String s)
  {
    Pattern p = Pattern.compile("\\d+(,\\d{2}){0,1}");
    Matcher m = p.matcher(s);
    return m.matches();
  }

  public static boolean isValidSignedAmount(String s)
  {
    Pattern p = Pattern.compile("[+-]{0,1}\\d+(,\\d{2}){0,1}");
    Matcher m = p.matcher(s);
    return m.matches();
  }

  public static boolean isValidPrice(String s)
  {
    Pattern p = Pattern.compile("\\d+(,\\d{2,5}){0,1}");
    Matcher m = p.matcher(s);
    return m.matches();
  }

  public static boolean isValidSignedPrice(String s)
  {
    Pattern p = Pattern.compile("[+-]{0,1}\\d+(,\\d{2,5}){0,1}");
    Matcher m = p.matcher(s);
    return m.matches();
  }
  
  public static boolean isInRange(String s, int precision, int scale)
  {
    Pattern p = Pattern.compile(
        "[+-]{0,1}\\d{1," + 
        (precision - scale) + 
        "}(,\\d{1," +
        scale + 
        "}){0,1}");
    Matcher m = p.matcher(s);
    return m.matches();
  }

  public static boolean isValidPerc(String s)
  {
    Pattern p = Pattern.compile("(100|\\d{1,2}(,\\d{1,3}){0,1})");
    Matcher m = p.matcher(s);
    return m.matches();
  }

  public static boolean isZero(String s)
  {
    Pattern p = Pattern.compile("0(,0+){0,1}");
    Matcher m = p.matcher(s);
    return m.matches();
  }
  
  public static String toStringAmount(BigDecimal bd)
  {
    return amountFormat.format(bd.doubleValue());
  }
  
  public static String toStringPositiveAmount(BigDecimal bd)
  {
    return amountFormat.format(bd.abs().doubleValue());
  }
  
  public static String toStringPrice(BigDecimal bd)
  {
    return priceFormat.format(bd.doubleValue());
  }
  
  public static String toStringPerc(BigDecimal bd)
  {
    return percFormat.format(bd.doubleValue());
  }
}
