/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package it.laitspa.cpf.faces.utils.validator;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.jsf.ValidatorConfig;
import javax.faces.application.Application;

/**
 *
 * @author Andrea
 */
public class PartitaIvaValidatorHandler extends CustomValidatorHandler{

    /**
   * 
   */
  private static final long serialVersionUID = 1L;
    private TagAttribute mustBeUnique;
    private TagAttribute codice;
    private TagAttribute validatorType;
    private TagAttribute componentStatoId;
    private TagAttribute componentTipoFornitoreId;
    
    public PartitaIvaValidatorHandler(ValidatorConfig config)
    {
        super(config);
        if (this.getAttribute("validatorType") != null)
            validatorType = this.getAttribute("validatorType");
        if (this.getAttribute("componentStatoId") != null)
            componentStatoId = this.getAttribute("componentStatoId");
        if (this.getAttribute("componentTipoFornitoreId") != null)
          componentTipoFornitoreId = this.getAttribute("componentTipoFornitoreId");
        if (this.getAttribute("mustBeUnique") != null)
            mustBeUnique = this.getAttribute("mustBeUnique");
        if (this.getAttribute("codice") != null)
            codice = this.getAttribute("codice");
    }

    @Override
    protected PartitaIvaValidator getValidator(FaceletContext ctx) {
        Application app = ctx.getFacesContext().getApplication();
        PartitaIvaValidator validator = (PartitaIvaValidator)
                app.createValidator(PartitaIvaValidator.PARTITAIVA_VALIDATORID);
        if(this.mustBeUnique != null)
            validator.setMustBeUnique(this.mustBeUnique.getValue(ctx));
        if(this.codice != null)
            validator.setCodice(this.codice.getInt(ctx));
        if (this.componentStatoId != null)
            validator.setComponentStatoId(this.componentStatoId.getValue(ctx));
        if (this.componentTipoFornitoreId != null)
          validator.setComponentTipoFornitoreId(this.componentTipoFornitoreId.getValue(ctx));
        if (this.validatorType != null)
            validator.setValidatorType(this.validatorType.getValue(ctx));
        return validator;
    }

}
