/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package it.laitspa.cpf.faces.utils.validator;

import java.io.Serializable;

import javax.faces.validator.Validator;

import org.apache.log4j.Logger;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.MetaRuleset;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.jsf.ValidateHandler;
import com.sun.facelets.tag.jsf.ValidatorConfig;

/**
 * 
 * @author Andrea
 */
public abstract class CustomValidatorHandler
  extends ValidateHandler
  implements Serializable
{

  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  protected Logger       logger;
  protected TagAttribute errorMessage;

  public CustomValidatorHandler(ValidatorConfig config)
  {
    super(config);
    logger = Logger.getLogger(this.getClass());
    if(this.getAttribute("errorMessage") != null)
      this.errorMessage = this.getAttribute("errorMessage");
    else
      this.errorMessage = null;
  }

  @Override
  protected Validator createValidator(FaceletContext ctx)
  {
    CustomValidator validator = getValidator(ctx);
    if(this.errorMessage != null)
    {
      validator.setErrorMessage(this.errorMessage.getValue(ctx));
    }
    return validator;
  }

  @SuppressWarnings("rawtypes")
  @Override
  protected MetaRuleset createMetaRuleset(Class type)
  {
    return super.createMetaRuleset(type).ignoreAll();
  }

  protected abstract CustomValidator getValidator(FaceletContext ctx);
}
