/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.faces.utils.component;

import java.io.Serializable;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.MetaRuleset;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.jsf.ComponentConfig;
import com.sun.facelets.tag.jsf.ComponentHandler;

/**
 * @author andrea
 *
 */
public class CpfPanelLayoutHandler
  extends ComponentHandler
  implements Serializable
{

  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  protected TagAttribute     columns;
  protected TagAttribute     width;
  
  
  /**
   * @param config
   */
  public CpfPanelLayoutHandler(ComponentConfig config)
  {
    super(config);
    if(this.getAttribute("columns") != null)
      this.columns = this.getAttribute("columns");
    if(this.getAttribute("width") != null)
      this.width = this.getAttribute("width");    
  }

  
  @Override
  protected UIComponent createComponent(FaceletContext ctx)
  {
    Application app = ctx.getFacesContext().getApplication();
    CpfPanelLayout p = (CpfPanelLayout) app.createComponent(CpfPanelLayout.COMPONENT_TYPE);
    if (columns != null)
      p.setColumns(this.columns.getInt(ctx));
    
   
    if (width != null)
      p.setWidth(this.width.getValue(ctx));
    
    return p;
  }
  
  @Override
  protected MetaRuleset createMetaRuleset(@SuppressWarnings("rawtypes") Class type)
  {
    return super.createMetaRuleset(type).ignoreAll();
  }
  
}
