/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package it.laitspa.cpf.faces.utils;

/**
 *
 * @author Andrea
 */
import java.io.Serializable;
import java.util.List;

/**
 * A simple class that represents a "page" of data out of a longer set, ie a
 * list of objects together with info to indicate the starting row and the full
 * size of the dataset. EJBs can return instances of this type when returning
 * subsets of available data.
 */
public class DataPage<T>
  implements Serializable
{

  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  private int               datasetSize;
  private int               startRow;
  private List<T>           data;

  /**
   * Create an object representing a sublist of a dataset.
   * 
   * @param datasetSize
   *          is the total number of matching rows available.
   * 
   * @param startRow
   *          is the index within the complete dataset of the first element in
   *          the data list.
   * 
   * @param data
   *          is a list of consecutive objects from the dataset.
   */
  public DataPage(int datasetSize, int startRow, List<T> data)
  {
    this.datasetSize = datasetSize;
    this.startRow = startRow;
    this.data = data;
  }

  /**
   * Return the number of items in the full dataset.
   */
  public int getDatasetSize()
  {
    return datasetSize;
  }

  /**
   * Return the offset within the full dataset of the first element in the list
   * held by this object.
   */
  public int getStartRow()
  {
    return startRow;
  }

  /**
   * Return the list of objects held by this object, which is a continuous
   * subset of the full dataset.
   */
  public List<T> getData()
  {
    return data;
  }
}
