/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
package it.laitspa.cpf.faces.streaming;

import it.laitspa.cpf.faces.utils.MimeUtils;
import it.laitspa.cpf.util.log.LogUtils;
import it.laitspa.cpf.util.misc.Base64Utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

import javax.naming.InitialContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class FileSystemZipAwareServlet
  extends HttpServlet
{
    /**
   * 
   */
  private static final long serialVersionUID = 1L;

    @SuppressWarnings("resource")
    @Override
  protected void service(HttpServletRequest req, HttpServletResponse res)
    throws ServletException, IOException
  {
    // Logger
    //
    LogUtils.info(getClass(), "FileSystem zip aware content.");
    
    // Declare output stream.
    //
    BufferedOutputStream bos = null;
    
    // Declare input stream.
    //
    InputStream is = null;
    File child = null;
    boolean isDeleteRequired = false;
    
    try
    {
      // Retrieve StreamingBean 
      //
      HttpSession ses = req.getSession();
      StreamingBean saf = (StreamingBean)ses.getAttribute("StreamingBean");
      
      // Checking if invoked by Bean or directly.
      //
      if (saf != null)
        isDeleteRequired = saf.isCanDelete();
      
      InitialContext ctx = new InitialContext();
      URL url = (URL) ctx.lookup("sanfer/fsroot");
      File root = new File(url.toURI());
      
      // Retrieve request parameter. 
      //
      String childPath = req.getParameter("file");
      if (childPath != null)
      {
        if (Base64Utils.isBase64(childPath))
          childPath = Base64Utils.decodeString(childPath);
      }
      else if (childPath == null && saf != null)
      {
        childPath = saf.getFileName();
      }
      
      child = new File(root, childPath);
      
      // Redirect if resource is not available.
      //
      if (!child.exists())
      {
        LogUtils.error(getClass(), MessageFormat.format("The requested resource on file system {0} does not exists.", new Object[]{childPath}));
        RequestDispatcher dispatcher = req.getRequestDispatcher("/faces/common/error/errorresourcepage.xhtml");
        dispatcher.forward(req, res);
        return;
      }
      
      FileInputStream fis = new FileInputStream(child);
      
      // Boolean unzip
      //
      boolean unzip = true;
      String unz = req.getParameter("unzip");
      if (unz != null)
        unzip = Boolean.parseBoolean(unz);
      
      // Decide if the file is a zipped one.
      //
      String type = MimeUtils.getMimeType(child.getAbsolutePath());
      if(type != null && unzip && type.equals("application/zip"))
      {
        // Calculate zip entry size.
        // 
        ZipFile zf = new ZipFile(child);
        Enumeration<? extends ZipEntry> e = zf.entries();
        ZipEntry ze = e.nextElement();
        if(ze == null)
        {
          LogUtils.error(getClass(), "No entries found in zip file.");
          return;
        }
        int length = (int)ze.getSize();

        
        // Open zip stream.
        //
        ZipInputStream zis = new ZipInputStream(fis);
        zis.getNextEntry();
        
        
        // Set content type of inner file.
        //
        type = MimeUtils.getMimeType(ze.getName());
        res.setContentType(type);
        
        // Set content length.
        //
        res.setContentLength(length);
        
        // Set headers.
        //
        res.setHeader("Content-Disposition", 
            "attachment; filename=\"" + ze.getName() + "\"");

        is = zis;
      }
      else
      {
        // Set content type.
        //
        res.setContentType(type);
        
        // Set content length.
        //
        res.setContentLength((int) child.length());
        
        // Set headers.
        //
        res.setHeader("Content-Disposition", 
            "attachment; filename=\"" + child.getName() + "\"");
        
        is = fis;
      }
      
      // Output data to response stream.
      //
      bos = new BufferedOutputStream(res.getOutputStream(), 16384);
      int c;
      while ((c = is.read()) != -1)
        bos.write(c);
      bos.flush();
      
    }
    catch (Exception e)
    {
      LogUtils.error(getClass(), "Exception caught while processing file.", e);
    }
    finally
    {
      
      // Close output stream.
      //
      /*
      if(bos != null)
      {
        try
        {
          bos.close();
          LogUtils.info(getClass(), "Closing output stream.");
        }
        catch (IOException ex)
        {
          LogUtils.error(getClass(), "IOException while closing stream.", ex);
        }
      }
      */
      // Close input stream.
      //
      if(is != null)
      {
        try
        {
          is.close();
          LogUtils.info(getClass(), "Closing input stream.");
        }
        catch (IOException ex)
        {
          LogUtils.error(getClass(), "IOException while closing stream.", ex);
        }
      }
      
      // Check if delete is required.
      //
      if (child != null && isDeleteRequired
          && child.exists() && child.delete())
        LogUtils.info(getClass(), "Streaming file successfully deleted.");
    }
  }
}
